/*
 * Decompiled with CFR 0.152.
 */
package com.egarantias.controller;

import com.egarantias.dto.InstitutionDTO;
import com.egarantias.dto.UserCompanyDTO;
import com.egarantias.models.Institution;
import com.egarantias.models.UserCompany;
import com.egarantias.services.CompanyService;
import java.util.List;
import java.util.Map;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/company"})
public class CompanyController {
    private final CompanyService companyService;

    public CompanyController(CompanyService companyService) {
        this.companyService = companyService;
    }

    @PostMapping(value={"/create"})
    public ResponseEntity<?> create(@RequestBody UserCompanyDTO dto) {
        UserCompany company = this.companyService.createCompanyWithDocuments(dto);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)"Registado com sucesso");
    }

    @PostMapping(value={"/create_institution"})
    public ResponseEntity<?> createInstitution(@RequestBody InstitutionDTO dto) {
        boolean resp = this.companyService.createInstitution(dto);
        if (resp) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)"Registado com sucesso");
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)"N\u00e3o foi poss\u00edvel satisfazer o seu pedido.");
    }

    @GetMapping(value={"/list_institutions"})
    public ResponseEntity<?> listAllInstitutions() {
        List resp = this.companyService.getAllInstitution();
        return ResponseEntity.ok((Object)resp);
    }

    @GetMapping(value={"/my_institution"})
    public ResponseEntity<?> getMyInstitutions() {
        Institution resp = this.companyService.getInstitutionByUser();
        return ResponseEntity.ok((Object)resp);
    }

    @GetMapping(value={"/my_companies"})
    public ResponseEntity<?> listAllCompanies() {
        System.out.println("Show companny data ");
        List resp = this.companyService.getCompanyByUser();
        return ResponseEntity.ok((Object)resp);
    }

    @GetMapping(value={"/list_companies"})
    public ResponseEntity<?> getMyCompanies() {
        System.out.println("Show companny data ");
        List resp = this.companyService.allCompany();
        return ResponseEntity.ok((Object)resp);
    }

    @GetMapping(value={"/dashboard/metrics/{id}"})
    public ResponseEntity<?> dashboard_metrics(@PathVariable(value="id") Long id) {
        Map resp = this.companyService.getCompanyDashboardMatrics(id);
        return ResponseEntity.ok((Object)resp);
    }
}

