/*
 * Decompiled with CFR 0.152.
 */
package com.egarantias.controller;

import com.egarantias.dto.AnswerRequestActionDTO;
import com.egarantias.dto.ContractualGuaranteeDocumentsDto;
import com.egarantias.dto.GuaranteePaymentControlDTO;
import com.egarantias.dto.GuaranteesDTO;
import com.egarantias.dto.MissingDocumentsRequestDto;
import com.egarantias.dto.RequestGuaranteeActionDTO;
import com.egarantias.dto.ValidateContractualDocDTO;
import com.egarantias.models.BaseDocuments;
import com.egarantias.models.ContractualGuaranteeDocuments;
import com.egarantias.models.Documents;
import com.egarantias.models.GuaranteePaymentControl;
import com.egarantias.models.UserGuarantees;
import com.egarantias.services.GuaranteesService;
import java.util.List;
import java.util.Optional;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"api/guarantees"})
public class GuaranteesController {
    private GuaranteesService guaranteesService;

    public GuaranteesController(GuaranteesService guaranteesService) {
        this.guaranteesService = guaranteesService;
    }

    @PostMapping(value={"/send_request"})
    public ResponseEntity<?> create(@RequestBody GuaranteesDTO dto) {
        boolean resp = this.guaranteesService.registerGuaranteesRequest(dto);
        if (resp) {
            return ResponseEntity.ok((Object)"Pedido de garantia registado com sucesso.");
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)"N\u00e3o foi poss\u00edvel satisfazer o seu pedido.");
    }

    @GetMapping(value={"/by_user"})
    public ResponseEntity<?> getUserGuarantees() {
        List resp = this.guaranteesService.allGuaranteesByUser();
        System.out.println("Fund guarante " + String.valueOf(resp));
        return ResponseEntity.ok((Object)resp);
    }

    @GetMapping(value={"/by_institution"})
    public ResponseEntity<?> getInstitutionGuarantees() {
        List resp = this.guaranteesService.allGuaranteesByInstitution();
        return ResponseEntity.ok((Object)resp);
    }

    @GetMapping(value={"/by_company/{id}"})
    public ResponseEntity<?> getCompanyGuarantees(@PathVariable(value="id") Long id) {
        List resp = this.guaranteesService.allGuaranteesByCompany(id);
        return ResponseEntity.ok((Object)resp);
    }

    @GetMapping(value={"/by_id/{id}"})
    public ResponseEntity<?> getGuaranteesById(@PathVariable(value="id") Long id) {
        UserGuarantees resp = this.guaranteesService.getGuaranteesById(id);
        return ResponseEntity.ok((Object)resp);
    }

    @PostMapping(value={"/send_contractual_documents"})
    public ResponseEntity<?> createContractualDocs(@RequestBody ContractualGuaranteeDocumentsDto dto) throws Exception {
        boolean resp = this.guaranteesService.addContractualDocs(dto);
        if (resp) {
            return ResponseEntity.ok((Object)"Documentos enviados sucesso.");
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)"N\u00e3o foi poss\u00edvel satisfazer o seu pedido.");
    }

    @GetMapping(value={"/find_contractual_docs/{id}"})
    public ResponseEntity<?> findContractualGuaranteeDocuments(@PathVariable(value="id") Long id) {
        System.out.println("Start validation here ");
        ContractualGuaranteeDocuments resp = this.guaranteesService.getContractualGuaranteeDocuments(id);
        return ResponseEntity.ok((Object)resp);
    }

    @GetMapping(value={"guarantee_doc/{id}/download"})
    public ResponseEntity<byte[]> downloadDocument(@PathVariable Long id) {
        Documents doc = this.guaranteesService.getGuaranteeDocById(id);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"attachment; filename=\"" + doc.getName() + ".pdf\""})).contentType(MediaType.parseMediaType((String)doc.getFileType())).body((Object)doc.getFile());
    }

    @GetMapping(value={"guarantee_base_doc/{id}/download"})
    public ResponseEntity<byte[]> downloadBaseDocument(@PathVariable Long id) {
        BaseDocuments doc = this.guaranteesService.getGuaranteeBaseDocById(id);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"attachment; filename=\"" + doc.getName() + ".pdf\""})).contentType(MediaType.parseMediaType((String)doc.getFileType())).body((Object)doc.getFile());
    }

    @PostMapping(value={"/missing_docs"})
    public ResponseEntity<?> createContractualDocs(@RequestBody MissingDocumentsRequestDto dto) throws Exception {
        boolean resp = this.guaranteesService.saveMissingDocuments(dto);
        if (resp) {
            return ResponseEntity.ok((Object)"Documentos enviados sucesso.");
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)"N\u00e3o foi poss\u00edvel satisfazer o seu pedido.");
    }

    @GetMapping(value={"/list_missing_docs/{id}"})
    public ResponseEntity<?> findMissingDocuments(@PathVariable(value="id") Long id) {
        List resp = this.guaranteesService.listMissingDocuments(id);
        return ResponseEntity.ok((Object)resp);
    }

    @PostMapping(value={"/approve_guarantee"})
    public ResponseEntity<?> approveGuarantee(@RequestBody MissingDocumentsRequestDto dto) throws Exception {
        boolean resp = this.guaranteesService.saveGuaranteeFile(dto);
        if (resp) {
            return ResponseEntity.ok((Object)"Garantia aprovada sucesso.");
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)"N\u00e3o foi poss\u00edvel satisfazer o seu pedido.");
    }

    @PostMapping(value={"/reject_guarantee"})
    public ResponseEntity<?> rejectGuarantee(@RequestBody AnswerRequestActionDTO dto) throws Exception {
        boolean resp = this.guaranteesService.rejectGuarantee(dto);
        if (resp) {
            return ResponseEntity.ok((Object)"Garantia rejeitada com sucesso.");
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)"N\u00e3o foi poss\u00edvel satisfazer o seu pedido.");
    }

    @PostMapping(value={"/send_contractual_documents/client"})
    public ResponseEntity<?> createContractualDocsClient(@RequestBody ContractualGuaranteeDocumentsDto dto) throws Exception {
        boolean resp = this.guaranteesService.submitContractualFiles(dto);
        if (resp) {
            return ResponseEntity.ok((Object)"Documentos enviados sucesso.");
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)"N\u00e3o foi poss\u00edvel satisfazer o seu pedido.");
    }

    @PostMapping(value={"/contractual_doc/validate"})
    public ResponseEntity<?> createContractualDocsClient(@RequestBody ValidateContractualDocDTO dto) throws Exception {
        this.guaranteesService.validateContractualDocs(dto);
        return ResponseEntity.ok((Object)"Done");
    }

    @PostMapping(value={"/payment/send"})
    public ResponseEntity<?> make_guarantee_payment(@RequestBody GuaranteePaymentControlDTO dto) throws Exception {
        this.guaranteesService.makeGuaranteePayment(dto);
        return ResponseEntity.ok((Object)"Done");
    }

    @GetMapping(value={"/payment/get/{id}"})
    public ResponseEntity<?> make_guarantee_payment(@PathVariable(value="id") Long id) throws Exception {
        GuaranteePaymentControl resp = this.guaranteesService.getGuaranteePayment(id);
        return ResponseEntity.ok((Object)resp);
    }

    @PostMapping(value={"/request/action"})
    public ResponseEntity<?> request_guarantee_action(@RequestBody RequestGuaranteeActionDTO request) {
        this.guaranteesService.requestGuaranteeAction(request);
        return ResponseEntity.ok((Object)"Done");
    }

    @GetMapping(value={"/request_action/get/{id}"})
    public ResponseEntity<?> get_request_action_guarantee(@PathVariable(value="id") Long id) throws Exception {
        List resp = this.guaranteesService.getRequestActionByGuarantee(id);
        return ResponseEntity.ok((Object)resp);
    }

    @GetMapping(value={"/request_action/get_by_id/{id}"})
    public ResponseEntity<?> get_request_action(@PathVariable(value="id") Long id) throws Exception {
        Optional resp = this.guaranteesService.getRequestAction(id);
        return ResponseEntity.ok((Object)resp);
    }

    @PostMapping(value={"request_action/answer"})
    public ResponseEntity<?> answer_guarantee_action(@RequestBody AnswerRequestActionDTO request) {
        boolean resp = this.guaranteesService.answerRequestAction(request);
        if (resp) {
            return ResponseEntity.ok((Object)"Processado com sucesso.");
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)"N\u00e3o foi poss\u00edvel satisfazer o seu pedido.");
    }
}

