/*
 * Decompiled with CFR 0.152.
 */
package com.egarantias.controller;

import com.egarantias.dto.InstitutionSettingsDTO;
import com.egarantias.models.InstitutionSettings;
import com.egarantias.services.InstitutionService;
import java.util.Map;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"api/institution"})
public class InstitutionController {
    private InstitutionService institutionService;

    public InstitutionController(InstitutionService institutionService) {
        this.institutionService = institutionService;
    }

    @PostMapping(value={"settings/create"})
    public ResponseEntity<?> create_settings(@RequestBody InstitutionSettingsDTO request) {
        Map resp = this.institutionService.createSettings(request);
        boolean saved = (Boolean)resp.get("saved");
        String message = (String)resp.get("message");
        if (saved) {
            return ResponseEntity.ok((Object)message);
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)message);
    }

    @GetMapping(value={"settings/get/{id}"})
    public ResponseEntity<?> get_settings(@PathVariable(value="id") Long id) {
        InstitutionSettings resp = this.institutionService.getSettings(id);
        return ResponseEntity.ok((Object)resp);
    }

    @GetMapping(value={"/dashboard/metrics/"})
    public ResponseEntity<?> dashboard_metrics() {
        Map resp = this.institutionService.getDashboardMetrics();
        return ResponseEntity.ok((Object)resp);
    }
}

