/*
 * Decompiled with CFR 0.152.
 */
package com.egarantias.controller;

import com.egarantias.controller.UserController;
import com.egarantias.dto.AnswerRequestActionDTO;
import com.egarantias.dto.AuthResponseDTO;
import com.egarantias.dto.ExecuteGuaranteeDTO;
import com.egarantias.dto.UserDto;
import com.egarantias.dto.UserKycDto;
import com.egarantias.dto.UserRegistrationRequest;
import com.egarantias.models.GuaranteeRequestAction;
import com.egarantias.models.UserGuarantees;
import com.egarantias.services.AuthService;
import com.egarantias.services.GuaranteesService;
import com.egarantias.services.UserServices;
import java.util.Map;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"api/user"})
public class UserController {
    private final UserServices registrationService;
    private final AuthService authService;
    private GuaranteesService guaranteesService;

    public UserController(UserServices registrationService, AuthService authService, GuaranteesService guaranteesService) {
        this.registrationService = registrationService;
        this.authService = authService;
        this.guaranteesService = guaranteesService;
    }

    @PostMapping(value={"/registration"})
    public ResponseEntity<String> register(@RequestBody UserRegistrationRequest request) {
        Map resp = this.registrationService.registerUserAndKyc(request);
        boolean saved = (Boolean)resp.get("saved");
        String message = (String)resp.get("message");
        if (saved) {
            return ResponseEntity.ok((Object)"Usu\u00e1rio registrados com sucesso.");
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)message);
    }

    @PostMapping(value={"/registration/applicant_user"})
    public ResponseEntity<String> create_user(@RequestBody UserDto request) {
        Map resp = this.registrationService.createApplicantUser(request);
        boolean saved = (Boolean)resp.get("saved");
        String message = (String)resp.get("message");
        if (saved) {
            return ResponseEntity.ok((Object)"Usu\u00e1rio registrados com sucesso.");
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)message);
    }

    @PostMapping(value={"/registration/kyc"})
    public ResponseEntity<String> create_user_kyc(@RequestBody UserKycDto request) {
        Map resp = this.registrationService.registerUserKyc(request);
        boolean saved = (Boolean)resp.get("saved");
        String message = (String)resp.get("message");
        if (saved) {
            return ResponseEntity.ok((Object)"Usu\u00e1rio registrados com sucesso.");
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)message);
    }

    @PostMapping(value={"/login"})
    public ResponseEntity<?> login(@RequestBody LoginRequest loginRequest) {
        AuthResponseDTO resp = this.authService.login(loginRequest.email, loginRequest.password);
        if (resp != null) {
            return ResponseEntity.ok((Object)resp);
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).body((Object)"Nome de usu\u00e1rio ou senha inv\u00e1lidos");
    }

    @GetMapping(value={"/verify_kyc"})
    public ResponseEntity<?> verify_kyc() {
        Map resp = this.registrationService.verifyUserKyc();
        return ResponseEntity.ok((Object)resp);
    }

    @GetMapping(value={"/guarantee/verify/{ref}"})
    public ResponseEntity<?> verify_kyc(@PathVariable(value="ref") String ref) {
        UserGuarantees resp = this.registrationService.verifyGuaranteeRef(ref);
        return ResponseEntity.ok((Object)resp);
    }

    @GetMapping(value={"/execute_guarantee/{id}"})
    public ResponseEntity<?> execute_guarantee(@PathVariable(value="id") Long id) throws Exception {
        this.guaranteesService.executeGuarantee(id);
        return ResponseEntity.ok((Object)"Done");
    }

    @GetMapping(value={"/execute_guarantee/validate/{otp}"})
    public ResponseEntity<?> execute_guarantee_validate(@PathVariable(value="otp") String otp) throws Exception {
        UserGuarantees resp = this.guaranteesService.validateGuaranteeOTP(otp);
        if (resp != null) {
            return ResponseEntity.ok((Object)resp);
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)"OTP invalido");
    }

    @PostMapping(value={"/execute_guarantee/execute/"})
    public ResponseEntity<?> execute_guarantee_validate(@RequestBody ExecuteGuaranteeDTO dto) throws Exception {
        this.guaranteesService.executeGuarantee(dto);
        return ResponseEntity.ok((Object)"");
    }

    @GetMapping(value={"/cancel_guarantee/details/{id}"})
    public ResponseEntity<?> details_cancel_guarantee(@PathVariable(value="id") Long id) throws Exception {
        GuaranteeRequestAction resp = this.guaranteesService.getRequestActionByGuaranteeId(id);
        return ResponseEntity.ok((Object)resp);
    }

    @PostMapping(value={"/cancel_guarantee/cancel/beneficiary/"})
    public ResponseEntity<?> answer_beneficiary_cancel_request(@RequestBody AnswerRequestActionDTO request) {
        boolean resp = this.guaranteesService.beneficiary_answer_cancel_request(request);
        if (resp) {
            return ResponseEntity.ok((Object)"Processado com sucesso.");
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)"N\u00e3o foi poss\u00edvel satisfazer o seu pedido.");
    }
}

