/*
 * Decompiled with CFR 0.152.
 */
package com.egarantias.models;

import com.egarantias.models.Base.BaseModel;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.persistence.Basic;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Lob;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import jakarta.validation.constraints.NotBlank;

@Entity
@Table(name="base_documents")
public class BaseDocuments
extends BaseModel {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @NotBlank
    private String name;
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    private byte[] file;
    @NotBlank
    @Column(name="file_type")
    private String fileType;

    @JsonIgnore
    public byte[] getFile() {
        return this.file;
    }

    @Transient
    @JsonProperty(value="downloadUrl")
    public String getDownloadUrl() {
        if (this.id == null) {
            return null;
        }
        return "http://apiegarantias.seal.co.mz:8080/api/guarantees/guarantee_base_doc/" + this.id + "/download";
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getFileType() {
        return this.fileType;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    public void setFile(byte[] file) {
        this.file = file;
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }
}

