/*
 * Decompiled with CFR 0.152.
 */
package com.egarantias.models;

import com.egarantias.models.Base.BaseModel;
import com.egarantias.models.BaseDocuments;
import com.egarantias.models.UserGuarantees;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

@Entity
@Table(name="contractual_guarantee_documents")
public class ContractualGuaranteeDocuments
extends BaseModel {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column(name="request_type")
    private String requestType;
    @Column(name="guarantee_fee")
    private BigDecimal guaranteeFee;
    @Column(name="contractual_doc_submitted")
    private boolean contractualDocSubmitted;
    @Column(name="contractual_doc_approved")
    private boolean contractualDocApproved;
    @Column(name="contractual_doc_rejected")
    private boolean contractualDocRejected;
    @Column(name="rejection_justification")
    private String rejectionJustification;
    @ManyToOne
    @JoinColumn(name="guarantee_id")
    private UserGuarantees guarantee;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="contractual_docs_id")
    @JsonIgnoreProperties(value={"file"})
    private List<BaseDocuments> contractFiles = new ArrayList();

    public Long getId() {
        return this.id;
    }

    public String getRequestType() {
        return this.requestType;
    }

    public BigDecimal getGuaranteeFee() {
        return this.guaranteeFee;
    }

    public boolean isContractualDocSubmitted() {
        return this.contractualDocSubmitted;
    }

    public boolean isContractualDocApproved() {
        return this.contractualDocApproved;
    }

    public boolean isContractualDocRejected() {
        return this.contractualDocRejected;
    }

    public String getRejectionJustification() {
        return this.rejectionJustification;
    }

    public UserGuarantees getGuarantee() {
        return this.guarantee;
    }

    public List<BaseDocuments> getContractFiles() {
        return this.contractFiles;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setRequestType(String requestType) {
        this.requestType = requestType;
    }

    public void setGuaranteeFee(BigDecimal guaranteeFee) {
        this.guaranteeFee = guaranteeFee;
    }

    public void setContractualDocSubmitted(boolean contractualDocSubmitted) {
        this.contractualDocSubmitted = contractualDocSubmitted;
    }

    public void setContractualDocApproved(boolean contractualDocApproved) {
        this.contractualDocApproved = contractualDocApproved;
    }

    public void setContractualDocRejected(boolean contractualDocRejected) {
        this.contractualDocRejected = contractualDocRejected;
    }

    public void setRejectionJustification(String rejectionJustification) {
        this.rejectionJustification = rejectionJustification;
    }

    public void setGuarantee(UserGuarantees guarantee) {
        this.guarantee = guarantee;
    }

    @JsonIgnoreProperties(value={"file"})
    public void setContractFiles(List<BaseDocuments> contractFiles) {
        this.contractFiles = contractFiles;
    }

    public ContractualGuaranteeDocuments() {
    }

    public ContractualGuaranteeDocuments(Long id, String requestType, BigDecimal guaranteeFee, boolean contractualDocSubmitted, boolean contractualDocApproved, boolean contractualDocRejected, String rejectionJustification, UserGuarantees guarantee, List<BaseDocuments> contractFiles) {
        this.id = id;
        this.requestType = requestType;
        this.guaranteeFee = guaranteeFee;
        this.contractualDocSubmitted = contractualDocSubmitted;
        this.contractualDocApproved = contractualDocApproved;
        this.contractualDocRejected = contractualDocRejected;
        this.rejectionJustification = rejectionJustification;
        this.guarantee = guarantee;
        this.contractFiles = contractFiles;
    }
}

