/*
 * Decompiled with CFR 0.152.
 */
package com.egarantias.models;

import com.egarantias.models.Base.BaseModel;
import com.egarantias.models.BaseDocuments;
import com.egarantias.models.PaymentMethod;
import com.egarantias.models.User;
import com.egarantias.models.UserGuarantees;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

@Entity
@Table(name="guarantee_payment_control")
public class GuaranteePaymentControl
extends BaseModel {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @NotNull
    @ManyToOne
    @JoinColumn(name="guarantee_id", nullable=false)
    private UserGuarantees guarantee;
    @ManyToOne
    @JoinColumn(name="user_id")
    private User user;
    @Enumerated(value=EnumType.STRING)
    @Column(name="payment_method", nullable=false)
    private PaymentMethod paymentMethod;
    @Column(name="mobile_number")
    private String mobileNumber;
    @Column(name="wallet")
    private String wallet;
    @Column(name="amount", nullable=false, precision=12, scale=2)
    private BigDecimal amount;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="proof_transfer_docs_id")
    @JsonIgnoreProperties(value={"file"})
    private List<BaseDocuments> proofTransferFiles = new ArrayList();

    public Long getId() {
        return this.id;
    }

    public UserGuarantees getGuarantee() {
        return this.guarantee;
    }

    public User getUser() {
        return this.user;
    }

    public PaymentMethod getPaymentMethod() {
        return this.paymentMethod;
    }

    public String getMobileNumber() {
        return this.mobileNumber;
    }

    public String getWallet() {
        return this.wallet;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public List<BaseDocuments> getProofTransferFiles() {
        return this.proofTransferFiles;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setGuarantee(UserGuarantees guarantee) {
        this.guarantee = guarantee;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void setPaymentMethod(PaymentMethod paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    public void setMobileNumber(String mobileNumber) {
        this.mobileNumber = mobileNumber;
    }

    public void setWallet(String wallet) {
        this.wallet = wallet;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    @JsonIgnoreProperties(value={"file"})
    public void setProofTransferFiles(List<BaseDocuments> proofTransferFiles) {
        this.proofTransferFiles = proofTransferFiles;
    }
}

