/*
 * Decompiled with CFR 0.152.
 */
package com.egarantias.models;

import com.egarantias.models.Base.BaseModel;
import com.egarantias.models.BaseDocuments;
import com.egarantias.models.UserGuarantees;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

@Entity
@Table(name="guarantee_request_action")
public class GuaranteeRequestAction
extends BaseModel {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @NotNull
    @ManyToOne
    @JoinColumn(name="guarantee_id", nullable=false)
    private UserGuarantees guarantee;
    @Column(name="requested_by_name")
    private String requestedByName;
    @Column(name="requested_by_email")
    private String requestedByEmail;
    @Column(name="new_description", length=1024)
    private String newDescription;
    @Column(name="old_description", length=1024)
    private String oldDescription;
    @Column(name="new_amount")
    private BigDecimal newAmount;
    @Column(name="old_amount")
    private BigDecimal oldAmount;
    @Column(name="new_duration")
    private String newDuration;
    @Column(name="old_duration")
    private String oldDuration;
    @Column(name="request_type")
    private String requestType;
    @Column(name="reason", length=1024)
    private String reason;
    @Column(name="status")
    private String status = "PENDING";
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="guarantee_request_action_id")
    @JsonIgnoreProperties(value={"file"})
    private List<BaseDocuments> documents = new ArrayList();

    public Long getId() {
        return this.id;
    }

    public UserGuarantees getGuarantee() {
        return this.guarantee;
    }

    public String getRequestedByName() {
        return this.requestedByName;
    }

    public String getRequestedByEmail() {
        return this.requestedByEmail;
    }

    public String getNewDescription() {
        return this.newDescription;
    }

    public String getOldDescription() {
        return this.oldDescription;
    }

    public BigDecimal getNewAmount() {
        return this.newAmount;
    }

    public BigDecimal getOldAmount() {
        return this.oldAmount;
    }

    public String getNewDuration() {
        return this.newDuration;
    }

    public String getOldDuration() {
        return this.oldDuration;
    }

    public String getRequestType() {
        return this.requestType;
    }

    public String getReason() {
        return this.reason;
    }

    public String getStatus() {
        return this.status;
    }

    public List<BaseDocuments> getDocuments() {
        return this.documents;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setGuarantee(UserGuarantees guarantee) {
        this.guarantee = guarantee;
    }

    public void setRequestedByName(String requestedByName) {
        this.requestedByName = requestedByName;
    }

    public void setRequestedByEmail(String requestedByEmail) {
        this.requestedByEmail = requestedByEmail;
    }

    public void setNewDescription(String newDescription) {
        this.newDescription = newDescription;
    }

    public void setOldDescription(String oldDescription) {
        this.oldDescription = oldDescription;
    }

    public void setNewAmount(BigDecimal newAmount) {
        this.newAmount = newAmount;
    }

    public void setOldAmount(BigDecimal oldAmount) {
        this.oldAmount = oldAmount;
    }

    public void setNewDuration(String newDuration) {
        this.newDuration = newDuration;
    }

    public void setOldDuration(String oldDuration) {
        this.oldDuration = oldDuration;
    }

    public void setRequestType(String requestType) {
        this.requestType = requestType;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    @JsonIgnoreProperties(value={"file"})
    public void setDocuments(List<BaseDocuments> documents) {
        this.documents = documents;
    }
}

