/*
 * Decompiled with CFR 0.152.
 */
package com.egarantias.models;

import com.egarantias.models.User;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.validation.constraints.Email;
import jakarta.validation.constraints.Pattern;

@Entity
@Table(name="institution")
public class Institution {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column(nullable=false)
    private String name;
    @Column(name="institution_type")
    private String institutionType;
    @Pattern(regexp="\\d{9}", message="NUIT deve ter exatamente 9 d\u00edgitos")
    private @Pattern(regexp="\\d{9}", message="NUIT deve ter exatamente 9 d\u00edgitos") String nuit;
    @Column(name="registration_number")
    private String registrationNumber;
    @Column
    private String address;
    @Column
    private String city;
    @Pattern(regexp="\\d{8,12}", message="O n\u00famero de telefone deve ter entre 8 e 12 d\u00edgitos")
    private @Pattern(regexp="\\d{8,12}", message="O n\u00famero de telefone deve ter entre 8 e 12 d\u00edgitos") String phone;
    @Email
    @Column
    private String email;
    @Column
    private String sector;
    @ManyToOne
    @JoinColumn(name="user_id")
    private User user;

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getInstitutionType() {
        return this.institutionType;
    }

    public String getNuit() {
        return this.nuit;
    }

    public String getRegistrationNumber() {
        return this.registrationNumber;
    }

    public String getAddress() {
        return this.address;
    }

    public String getCity() {
        return this.city;
    }

    public String getPhone() {
        return this.phone;
    }

    public String getEmail() {
        return this.email;
    }

    public String getSector() {
        return this.sector;
    }

    public User getUser() {
        return this.user;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setInstitutionType(String institutionType) {
        this.institutionType = institutionType;
    }

    public void setNuit(String nuit) {
        this.nuit = nuit;
    }

    public void setRegistrationNumber(String registrationNumber) {
        this.registrationNumber = registrationNumber;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setSector(String sector) {
        this.sector = sector;
    }

    public void setUser(User user) {
        this.user = user;
    }
}

