/*
 * Decompiled with CFR 0.152.
 */
package com.egarantias.models;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import java.time.LocalDateTime;
import java.util.UUID;

@Entity
@Table(name="generic_otp")
public class OTPModel {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column(nullable=false, unique=true)
    private String code;
    @Column(name="object_id")
    private Long objectId;
    @Column(nullable=false)
    private LocalDateTime expiresAt;
    @Column
    private String redirectUrlBase;
    @Column
    private String purpose;

    public boolean isExpired() {
        return LocalDateTime.now().isAfter(this.expiresAt);
    }

    public boolean isValid(String inputCode) {
        return this.code.equals(inputCode) && !this.isExpired();
    }

    public String getFinalUrl() {
        if (this.redirectUrlBase != null && !this.redirectUrlBase.isEmpty()) {
            return this.redirectUrlBase + (this.redirectUrlBase.contains("?") ? "&" : "?") + "token=" + this.code;
        }
        return null;
    }

    public static OTPModel create(String redirectBaseUrl, int ttlHours, Long objectId) {
        OTPModel otp = new OTPModel();
        otp.code = UUID.randomUUID().toString().replace("-", "");
        otp.expiresAt = LocalDateTime.now().plusHours(ttlHours);
        otp.redirectUrlBase = redirectBaseUrl + otp.code;
        otp.objectId = objectId;
        return otp;
    }

    public static OTPModel createCodeOnly(int ttlMinutes, Long objectId) {
        OTPModel otp = new OTPModel();
        otp.code = UUID.randomUUID().toString().replace("-", "").substring(0, 6);
        otp.expiresAt = LocalDateTime.now().plusMinutes(ttlMinutes);
        otp.objectId = objectId;
        return otp;
    }

    public Long getId() {
        return this.id;
    }

    public String getCode() {
        return this.code;
    }

    public Long getObjectId() {
        return this.objectId;
    }

    public LocalDateTime getExpiresAt() {
        return this.expiresAt;
    }

    public String getRedirectUrlBase() {
        return this.redirectUrlBase;
    }

    public String getPurpose() {
        return this.purpose;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setObjectId(Long objectId) {
        this.objectId = objectId;
    }

    public void setExpiresAt(LocalDateTime expiresAt) {
        this.expiresAt = expiresAt;
    }

    public void setRedirectUrlBase(String redirectUrlBase) {
        this.redirectUrlBase = redirectUrlBase;
    }

    public void setPurpose(String purpose) {
        this.purpose = purpose;
    }
}

