/*
 * Decompiled with CFR 0.152.
 */
package com.egarantias.models;

import com.egarantias.models.Base.BaseModel;
import com.egarantias.models.CompanyDocument;
import com.egarantias.models.User;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonManagedReference;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.validation.constraints.Email;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.Pattern;
import java.util.ArrayList;
import java.util.List;

@Entity
@Table(name="user_company")
public class UserCompany
extends BaseModel {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @NotBlank
    private String companyName;
    @Pattern(regexp="\\d{9}", message="NUIT deve ter exatamente 9 d\u00edgitos")
    private @Pattern(regexp="\\d{9}", message="NUIT deve ter exatamente 9 d\u00edgitos") String nuit;
    @Column(name="institution_type", nullable=true)
    private String institutionType;
    @NotBlank
    private String registrationNumber;
    @NotBlank
    private String address;
    @Pattern(regexp="\\d{8,12}", message="O n\u00famero de telefone deve ter entre 8 e 12 d\u00edgitos")
    private @Pattern(regexp="\\d{8,12}", message="O n\u00famero de telefone deve ter entre 8 e 12 d\u00edgitos") String phone;
    @Email
    @NotBlank
    private String email;
    @NotBlank
    private String sector;
    @Column
    private String city;
    @Column(name="contact_person_name")
    private String contactPersonName;
    @Column(name="contact_person_phone")
    private String contactPersonPhone;
    @ManyToOne
    @JoinColumn(name="user_id")
    private User user;
    @OneToMany(mappedBy="company", cascade={CascadeType.ALL}, orphanRemoval=true)
    @JsonIgnoreProperties(value={"file"})
    @JsonManagedReference
    private List<CompanyDocument> documents = new ArrayList();

    public Long getId() {
        return this.id;
    }

    public String getCompanyName() {
        return this.companyName;
    }

    public String getNuit() {
        return this.nuit;
    }

    public String getInstitutionType() {
        return this.institutionType;
    }

    public String getRegistrationNumber() {
        return this.registrationNumber;
    }

    public String getAddress() {
        return this.address;
    }

    public String getPhone() {
        return this.phone;
    }

    public String getEmail() {
        return this.email;
    }

    public String getSector() {
        return this.sector;
    }

    public String getCity() {
        return this.city;
    }

    public String getContactPersonName() {
        return this.contactPersonName;
    }

    public String getContactPersonPhone() {
        return this.contactPersonPhone;
    }

    public User getUser() {
        return this.user;
    }

    public List<CompanyDocument> getDocuments() {
        return this.documents;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public void setNuit(String nuit) {
        this.nuit = nuit;
    }

    public void setInstitutionType(String institutionType) {
        this.institutionType = institutionType;
    }

    public void setRegistrationNumber(String registrationNumber) {
        this.registrationNumber = registrationNumber;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setSector(String sector) {
        this.sector = sector;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public void setContactPersonName(String contactPersonName) {
        this.contactPersonName = contactPersonName;
    }

    public void setContactPersonPhone(String contactPersonPhone) {
        this.contactPersonPhone = contactPersonPhone;
    }

    public void setUser(User user) {
        this.user = user;
    }

    @JsonIgnoreProperties(value={"file"})
    public void setDocuments(List<CompanyDocument> documents) {
        this.documents = documents;
    }

    public UserCompany() {
    }

    public UserCompany(Long id, String companyName, String nuit, String institutionType, String registrationNumber, String address, String phone, String email, String sector, String city, String contactPersonName, String contactPersonPhone, User user, List<CompanyDocument> documents) {
        this.id = id;
        this.companyName = companyName;
        this.nuit = nuit;
        this.institutionType = institutionType;
        this.registrationNumber = registrationNumber;
        this.address = address;
        this.phone = phone;
        this.email = email;
        this.sector = sector;
        this.city = city;
        this.contactPersonName = contactPersonName;
        this.contactPersonPhone = contactPersonPhone;
        this.user = user;
        this.documents = documents;
    }
}

