/*
 * Decompiled with CFR 0.152.
 */
package com.egarantias.models;

import com.egarantias.models.Base.BaseModel;
import com.egarantias.models.Documents;
import com.egarantias.models.Institution;
import com.egarantias.models.User;
import com.egarantias.models.UserCompany;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonManagedReference;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;

@Entity
@Table(name="user_guarantees")
public class UserGuarantees
extends BaseModel {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column(name="guarantee_type", nullable=false)
    private String guaranteeType;
    @Column(name="project_name", nullable=false)
    private String projectName;
    @Column(nullable=false, length=1024)
    private String description;
    @Column(name="guarantee_price", scale=2, precision=10)
    private BigDecimal guaranteePrice;
    @Column(name="guarantee_duration_month", nullable=false)
    private String guaranteeDurationMonth;
    @Column(name="beneficiary_institution")
    private String beneficiaryInstitution;
    @Column(name="beneficiary_institution_email")
    private String beneficiaryInstitutionEmail;
    @Column
    private String status = "PENDING";
    @Column(name="contract_submitted")
    private boolean contractSubmitted = false;
    @Column(name="contest_number")
    private String contestNumber;
    @Column(name="guarantee_start_date")
    private LocalDate guaranteeStartDate;
    @Column(name="guarantee_end_date")
    private LocalDate guaranteeEndDate;
    @Column(name="beneficiary_phone")
    private String beneficiaryPhone;
    @ManyToOne
    @JoinColumn(name="user_id")
    private User user;
    @ManyToOne
    @JoinColumn(name="guarantee_file")
    private Documents guaranteeFile;
    @ManyToOne
    @JoinColumn(name="institution_id")
    private Institution institution;
    @ManyToOne
    @JoinColumn(name="applicants_company_id")
    private UserCompany applicantsCompany;
    @Column(name="ref")
    private String ref;
    @Column(name="insurer_ref")
    private String insurerRef;
    @OneToMany(mappedBy="guarantees", cascade={CascadeType.ALL}, orphanRemoval=true)
    @JsonIgnoreProperties(value={"file"})
    @JsonManagedReference
    private List<Documents> documents = new ArrayList();

    public Long getId() {
        return this.id;
    }

    public String getGuaranteeType() {
        return this.guaranteeType;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getDescription() {
        return this.description;
    }

    public BigDecimal getGuaranteePrice() {
        return this.guaranteePrice;
    }

    public String getGuaranteeDurationMonth() {
        return this.guaranteeDurationMonth;
    }

    public String getBeneficiaryInstitution() {
        return this.beneficiaryInstitution;
    }

    public String getBeneficiaryInstitutionEmail() {
        return this.beneficiaryInstitutionEmail;
    }

    public String getStatus() {
        return this.status;
    }

    public boolean isContractSubmitted() {
        return this.contractSubmitted;
    }

    public String getContestNumber() {
        return this.contestNumber;
    }

    public LocalDate getGuaranteeStartDate() {
        return this.guaranteeStartDate;
    }

    public LocalDate getGuaranteeEndDate() {
        return this.guaranteeEndDate;
    }

    public String getBeneficiaryPhone() {
        return this.beneficiaryPhone;
    }

    public User getUser() {
        return this.user;
    }

    public Documents getGuaranteeFile() {
        return this.guaranteeFile;
    }

    public Institution getInstitution() {
        return this.institution;
    }

    public UserCompany getApplicantsCompany() {
        return this.applicantsCompany;
    }

    public String getRef() {
        return this.ref;
    }

    public String getInsurerRef() {
        return this.insurerRef;
    }

    public List<Documents> getDocuments() {
        return this.documents;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setGuaranteeType(String guaranteeType) {
        this.guaranteeType = guaranteeType;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setGuaranteePrice(BigDecimal guaranteePrice) {
        this.guaranteePrice = guaranteePrice;
    }

    public void setGuaranteeDurationMonth(String guaranteeDurationMonth) {
        this.guaranteeDurationMonth = guaranteeDurationMonth;
    }

    public void setBeneficiaryInstitution(String beneficiaryInstitution) {
        this.beneficiaryInstitution = beneficiaryInstitution;
    }

    public void setBeneficiaryInstitutionEmail(String beneficiaryInstitutionEmail) {
        this.beneficiaryInstitutionEmail = beneficiaryInstitutionEmail;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setContractSubmitted(boolean contractSubmitted) {
        this.contractSubmitted = contractSubmitted;
    }

    public void setContestNumber(String contestNumber) {
        this.contestNumber = contestNumber;
    }

    public void setGuaranteeStartDate(LocalDate guaranteeStartDate) {
        this.guaranteeStartDate = guaranteeStartDate;
    }

    public void setGuaranteeEndDate(LocalDate guaranteeEndDate) {
        this.guaranteeEndDate = guaranteeEndDate;
    }

    public void setBeneficiaryPhone(String beneficiaryPhone) {
        this.beneficiaryPhone = beneficiaryPhone;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void setGuaranteeFile(Documents guaranteeFile) {
        this.guaranteeFile = guaranteeFile;
    }

    public void setInstitution(Institution institution) {
        this.institution = institution;
    }

    public void setApplicantsCompany(UserCompany applicantsCompany) {
        this.applicantsCompany = applicantsCompany;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public void setInsurerRef(String insurerRef) {
        this.insurerRef = insurerRef;
    }

    @JsonIgnoreProperties(value={"file"})
    public void setDocuments(List<Documents> documents) {
        this.documents = documents;
    }
}

