/*
 * Decompiled with CFR 0.152.
 */
package com.egarantias.services;

import com.egarantias.dto.GuaranteeBeneficiaryApprovalMail;
import com.egarantias.dto.GuaranteeCancelDecisionMail;
import com.egarantias.dto.GuaranteeCancelRequestMail;
import com.egarantias.dto.GuaranteeDecisionMail;
import com.egarantias.dto.GuaranteeEditDecisionMail;
import com.egarantias.dto.GuaranteeEditRequestMail;
import com.egarantias.dto.GuaranteeExecutionApprovedMail;
import com.egarantias.dto.GuaranteeExecutionRejectedMail;
import com.egarantias.dto.GuaranteeExecutionRequestMail;
import com.egarantias.services.EmailServiceCTA;
import com.egarantias.utils.MailAddress;
import com.egarantias.utils.MailTemplates;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeMessage;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;
import org.thymeleaf.spring6.SpringTemplateEngine;

@Service
public class AdvancedEmailService
implements EmailServiceCTA {
    @Autowired
    private final JavaMailSender mailSender;
    private final SpringTemplateEngine templateEngine;
    @Value(value="${spring.mail.username}")
    private String from;
    @Value(value="${spring.mail.replyTo:}")
    private String replyTo;
    @Value(value="${app.base-front-url}")
    private String appBaseUrl;

    public AdvancedEmailService(JavaMailSender mailSender, SpringTemplateEngine templateEngine) {
        this.mailSender = mailSender;
        this.templateEngine = templateEngine;
    }

    @Async
    @Retryable(maxAttempts=3, backoff=@Backoff(delay=1500L, multiplier=2.0))
    public void sendGuaranteeEditRequest(GuaranteeEditRequestMail data) {
        Context ctx = new Context();
        ctx.setVariable("guaranteeId", (Object)data.guaranteeId());
        ctx.setVariable("guaranteeNumber", (Object)data.guaranteeNumber());
        ctx.setVariable("requestedByName", (Object)data.requestedByName());
        ctx.setVariable("requestedByEmail", (Object)data.requestedByEmail());
        ctx.setVariable("requestedAt", (Object)data.requestedAt());
        ctx.setVariable("proposedChanges", (Object)data.proposedChanges());
        ctx.setVariable("appBaseUrl", (Object)this.appBaseUrl);
        String html = this.templateEngine.process(MailTemplates.GUARANTEE_EDIT_REQUEST.get(), (IContext)ctx);
        String subject = data.subjectOverride() != null && !data.subjectOverride().isBlank() ? data.subjectOverride() : "Pedido de edi\u00e7\u00e3o da garantia #" + data.guaranteeNumber();
        this.sendMultipartHtml(data.recipients(), subject, html);
    }

    @Async
    @Retryable(maxAttempts=3, backoff=@Backoff(delay=1500L, multiplier=2.0))
    public void sendGuaranteeEditDecision(GuaranteeEditDecisionMail data) {
        Context ctx = new Context();
        ctx.setVariable("guaranteeId", (Object)data.guaranteeId());
        ctx.setVariable("guaranteeNumber", (Object)data.guaranteeNumber());
        ctx.setVariable("approved", (Object)data.approved());
        ctx.setVariable("decidedByName", (Object)data.decidedByName());
        ctx.setVariable("decidedAt", (Object)data.decidedAt());
        ctx.setVariable("decisionNotes", (Object)data.decisionNotes());
        ctx.setVariable("appBaseUrl", (Object)this.appBaseUrl);
        String html = this.templateEngine.process(MailTemplates.GUARANTEE_EDIT_DECISION.get(), (IContext)ctx);
        String status = data.approved() ? "APROVADO" : "RECUSADO";
        String subject = data.subjectOverride() != null && !data.subjectOverride().isBlank() ? data.subjectOverride() : "Resultado do pedido de edi\u00e7\u00e3o (" + status + ") - garantia #" + data.guaranteeNumber();
        this.sendMultipartHtml(data.recipients(), subject, html);
    }

    @Async
    @Retryable(maxAttempts=3, backoff=@Backoff(delay=1500L, multiplier=2.0))
    public void sendGuaranteeCancelRequest(GuaranteeCancelRequestMail data) {
        Context ctx = new Context();
        ctx.setVariable("guaranteeId", (Object)data.guaranteeId());
        ctx.setVariable("guaranteeNumber", (Object)data.guaranteeNumber());
        ctx.setVariable("requestedByName", (Object)data.requestedByName());
        ctx.setVariable("requestedByEmail", (Object)data.requestedByEmail());
        ctx.setVariable("requestedAt", (Object)data.requestedAt());
        ctx.setVariable("reason", (Object)data.reason());
        ctx.setVariable("appBaseUrl", (Object)this.appBaseUrl);
        String html = this.templateEngine.process("guarantee-cancel-request", (IContext)ctx);
        String subject = data.subjectOverride() != null && !data.subjectOverride().isBlank() ? data.subjectOverride() : "Pedido de cancelamento da garantia #" + data.guaranteeNumber();
        this.sendMultipartHtml(data.recipients(), subject, html);
    }

    @Async
    @Retryable(maxAttempts=3, backoff=@Backoff(delay=1500L, multiplier=2.0))
    public void sendGuaranteeCancelDecision(GuaranteeCancelDecisionMail data) {
        Context ctx = new Context();
        ctx.setVariable("guaranteeId", (Object)data.guaranteeId());
        ctx.setVariable("guaranteeNumber", (Object)data.guaranteeNumber());
        ctx.setVariable("approved", (Object)data.approved());
        ctx.setVariable("decidedByName", (Object)data.decidedByName());
        ctx.setVariable("decidedAt", (Object)data.decidedAt());
        ctx.setVariable("decisionNotes", (Object)data.decisionNotes());
        ctx.setVariable("appBaseUrl", (Object)this.appBaseUrl);
        String html = this.templateEngine.process("guarantee-cancel-decision", (IContext)ctx);
        String status = data.approved() ? "APROVADO" : "RECUSADO";
        String subject = data.subjectOverride() != null && !data.subjectOverride().isBlank() ? data.subjectOverride() : "Resultado do pedido de cancelamento (" + status + ") - garantia #" + data.guaranteeNumber();
        this.sendMultipartHtml(data.recipients(), subject, html);
    }

    @Async
    @Retryable(maxAttempts=3, backoff=@Backoff(delay=1500L, multiplier=2.0))
    public void sendBeneficiaryApprovalRequest(GuaranteeBeneficiaryApprovalMail data) {
        Context ctx = new Context();
        ctx.setVariable("guaranteeId", (Object)data.guaranteeId());
        ctx.setVariable("guaranteeNumber", (Object)data.guaranteeNumber());
        ctx.setVariable("beneficiaryName", (Object)data.beneficiaryName());
        ctx.setVariable("beneficiaryEmail", (Object)data.beneficiaryEmail());
        ctx.setVariable("requestedByName", (Object)data.requestedByName());
        ctx.setVariable("requestedByEmail", (Object)data.requestedByEmail());
        ctx.setVariable("requestedAt", (Object)data.requestedAt());
        ctx.setVariable("proposedChanges", (Object)data.proposedChanges());
        ctx.setVariable("approvalUrl", (Object)data.approvalUrl());
        ctx.setVariable("rejectUrl", (Object)data.rejectUrl());
        ctx.setVariable("deadlineHours", (Object)72);
        ctx.setVariable("appBaseUrl", (Object)this.appBaseUrl);
        String html = this.templateEngine.process(MailTemplates.GUARANTEE_BENEFICIARY_APPROVAL.get(), (IContext)ctx);
        String subject = data.subjectOverride() != null && !data.subjectOverride().isBlank() ? data.subjectOverride() : "A\u00e7\u00e3o necess\u00e1ria: Aprova\u00e7\u00e3o da Garantia #" + data.guaranteeNumber();
        this.sendMultipartHtml(data.recipients(), subject, html);
    }

    @Async
    @Retryable(maxAttempts=3, backoff=@Backoff(delay=1500L, multiplier=2.0))
    public void sendGuaranteeExecutionRequest(GuaranteeExecutionRequestMail data) {
        Context ctx = new Context();
        ctx.setVariable("guaranteeId", (Object)data.guaranteeId());
        ctx.setVariable("guaranteeNumber", (Object)data.guaranteeNumber());
        ctx.setVariable("requestedByName", (Object)data.requestedByName());
        ctx.setVariable("requestedByEmail", (Object)data.requestedByEmail());
        ctx.setVariable("requestedAt", (Object)data.requestedAt());
        ctx.setVariable("reason", (Object)data.reason());
        ctx.setVariable("appBaseUrl", (Object)this.appBaseUrl);
        String html = this.templateEngine.process(MailTemplates.GUARANTEE_EXECUTION_REQUEST.get(), (IContext)ctx);
        String subject = data.subjectOverride() != null && !data.subjectOverride().isBlank() ? data.subjectOverride() : "Pedido de execu\u00e7\u00e3o da Garantia #" + data.guaranteeNumber();
        this.sendMultipartHtml(data.recipients(), subject, html);
    }

    @Async
    @Retryable(maxAttempts=3, backoff=@Backoff(delay=1500L, multiplier=2.0))
    public void sendGuaranteeExecutionApproved(GuaranteeExecutionApprovedMail data) {
        Context ctx = new Context();
        ctx.setVariable("guaranteeId", (Object)data.guaranteeId());
        ctx.setVariable("guaranteeNumber", (Object)data.guaranteeNumber());
        ctx.setVariable("approvedAt", (Object)data.approvedAt());
        ctx.setVariable("appBaseUrl", (Object)this.appBaseUrl);
        String html = this.templateEngine.process(MailTemplates.GUARANTEE_EXECUTION_APPROVED.get(), (IContext)ctx);
        String subject = data.subjectOverride() != null && !data.subjectOverride().isBlank() ? data.subjectOverride() : "Execu\u00e7\u00e3o aprovada para Garantia #" + data.guaranteeNumber();
        this.sendMultipartHtml(data.recipients(), subject, html);
    }

    @Async
    @Retryable(maxAttempts=3, backoff=@Backoff(delay=1500L, multiplier=2.0))
    public void sendGuaranteeExecutionRejected(GuaranteeExecutionRejectedMail data) {
        Context ctx = new Context();
        ctx.setVariable("guaranteeId", (Object)data.guaranteeId());
        ctx.setVariable("guaranteeNumber", (Object)data.guaranteeNumber());
        ctx.setVariable("rejectedAt", (Object)data.rejectedAt());
        ctx.setVariable("rejectedBy", (Object)data.rejectedBy());
        ctx.setVariable("reason", (Object)data.reason());
        ctx.setVariable("appBaseUrl", (Object)this.appBaseUrl);
        String html = this.templateEngine.process(MailTemplates.GUARANTEE_EXECUTION_REJECTED.get(), (IContext)ctx);
        String subject = data.subjectOverride() != null && !data.subjectOverride().isBlank() ? data.subjectOverride() : "Execu\u00e7\u00e3o da Garantia #" + data.guaranteeNumber() + " foi recusada";
        this.sendMultipartHtml(data.recipients(), subject, html);
    }

    @Async
    @Retryable(maxAttempts=3, backoff=@Backoff(delay=1500L, multiplier=2.0))
    public void sendGuaranteeIssueRejectedMail(GuaranteeDecisionMail data) {
        Context ctx = new Context();
        ctx.setVariable("guaranteeId", (Object)data.guaranteeId());
        ctx.setVariable("guaranteeNumber", (Object)data.guaranteeNumber());
        ctx.setVariable("insurerName", (Object)data.insurerName());
        ctx.setVariable("decidedByName", (Object)data.decidedByName());
        ctx.setVariable("decidedAt", (Object)data.decidedAt());
        ctx.setVariable("requestedAt", (Object)data.requestedAt());
        ctx.setVariable("decisionNotes", (Object)data.decisionNotes());
        ctx.setVariable("appBaseUrl", (Object)this.appBaseUrl);
        String html = this.templateEngine.process(MailTemplates.GUARANTEE_ISSUE_REJECTED.get(), (IContext)ctx);
        String subject = "Emiss\u00e3o de Garantia Rejeitada - #" + data.guaranteeNumber();
        this.sendMultipartHtml(data.recipients(), subject, html);
    }

    private void sendMultipartHtml(List<MailAddress> recipients, String subject, String html) {
        try {
            MimeMessage message = this.mailSender.createMimeMessage();
            System.out.println("SHOW MESSAGE " + String.valueOf(message));
            MimeMessageHelper helper = new MimeMessageHelper(message, 3, StandardCharsets.UTF_8.name());
            helper.setFrom(new InternetAddress(this.from));
            if (this.replyTo != null && !this.replyTo.isBlank()) {
                helper.setReplyTo(this.replyTo);
            }
            helper.setSubject(subject);
            String[] to = (String[])recipients.stream().map(r -> r.email()).toArray(String[]::new);
            helper.setTo(to);
            helper.setText(html, true);
            System.out.println("SHOW MESSAGE 11" + String.valueOf(message));
            this.mailSender.send(message);
            System.out.println("SHOW MESSAGE 12" + String.valueOf(this.mailSender));
        }
        catch (MessagingException ex) {
            throw new RuntimeException("Erro ao enviar e-mail: " + ex.getMessage(), ex);
        }
    }
}

