/*
 * Decompiled with CFR 0.152.
 */
package com.egarantias.services;

import com.egarantias.dto.AuthResponseDTO;
import com.egarantias.dto.UserDto;
import com.egarantias.models.User;
import com.egarantias.services.repository.UserRepository;
import com.egarantias.utils.Jwt;
import java.util.Optional;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;

@Service
public class AuthService {
    private final UserRepository userRepository;
    private final PasswordEncoder passwordEncoder;
    private final Jwt jwtUtil;

    public AuthService(UserRepository userRepository, PasswordEncoder passwordEncoder, Jwt jwtUtil) {
        this.userRepository = userRepository;
        this.passwordEncoder = passwordEncoder;
        this.jwtUtil = jwtUtil;
    }

    public AuthResponseDTO login(String email, String rawPassword) {
        Optional userOpt = this.userRepository.findByEmail(email);
        if (userOpt.isEmpty()) {
            return null;
        }
        User user = (User)userOpt.get();
        if (this.passwordEncoder.matches((CharSequence)rawPassword, user.getPassword())) {
            UserDto userDto = new UserDto(user);
            String jwt = this.jwtUtil.generateToken(user.getUsername());
            System.out.println("The token jwt validation " + jwt);
            AuthResponseDTO responde = new AuthResponseDTO(jwt, userDto);
            return responde;
        }
        return null;
    }
}

