/*
 * Decompiled with CFR 0.152.
 */
package com.egarantias.services;

import com.egarantias.dto.InstitutionDTO;
import com.egarantias.dto.UserCompanyDTO;
import com.egarantias.models.CompanyDocument;
import com.egarantias.models.Institution;
import com.egarantias.models.User;
import com.egarantias.models.UserCompany;
import com.egarantias.services.repository.CompanyDocumentRepository;
import com.egarantias.services.repository.InstitutionRepository;
import com.egarantias.services.repository.UserCompanyRepository;
import com.egarantias.services.repository.UserGuaranteesRepository;
import com.egarantias.services.repository.UserRepository;
import com.egarantias.utils.UserUtils;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service
public class CompanyService {
    private final UserRepository userRepository;
    private final UserCompanyRepository companyRepository;
    private final CompanyDocumentRepository companyDocumentRepository;
    private final InstitutionRepository institutionRepository;
    private final UserUtils userUtils;
    private final UserGuaranteesRepository userGuaranteesRepository;

    public CompanyService(UserRepository userRepository, UserCompanyRepository companyRepository, CompanyDocumentRepository companyDocumentRepository, InstitutionRepository institutionRepository, UserUtils userUtils, UserGuaranteesRepository userGuaranteesRepository) {
        this.userRepository = userRepository;
        this.companyRepository = companyRepository;
        this.companyDocumentRepository = companyDocumentRepository;
        this.institutionRepository = institutionRepository;
        this.userUtils = userUtils;
        this.userGuaranteesRepository = userGuaranteesRepository;
    }

    public UserCompany createCompanyWithDocuments(UserCompanyDTO dto) {
        UserCompany company = new UserCompany();
        User user = this.userUtils.getLoggedUser();
        company.setUser(user);
        company.setCompanyName(dto.getCompanyName());
        company.setEmail(dto.getEmail());
        company.setRegistrationNumber(dto.getRegistrationNumber());
        company.setAddress(dto.getAddress());
        company.setSector(dto.getBusinessSector());
        company.setNuit(dto.getNuit());
        company.setPhone(dto.getPhone());
        company.setContactPersonName(dto.getContactPersonName());
        company.setContactPersonPhone(dto.getContactPersonPhone());
        company.setCity("");
        company.setInstitutionType("");
        List<CompanyDocument> documents = dto.getDocuments().stream().map(docDto -> {
            CompanyDocument doc = new CompanyDocument();
            doc.setName(docDto.getName());
            doc.setFileType(docDto.getFileType());
            doc.setFile(Base64.getDecoder().decode(docDto.getFile()));
            doc.setCompany(company);
            return doc;
        }).toList();
        company.setDocuments(documents);
        return (UserCompany)this.companyRepository.save((Object)company);
    }

    public boolean createInstitution(InstitutionDTO request) {
        try {
            Institution institution = new Institution();
            Long userId = request.getUserId();
            User user = new User();
            if (userId != null) {
                Optional usr = this.userRepository.findById((Object)userId);
                if (usr.isEmpty()) {
                    System.out.println("User not found");
                    return false;
                }
                user = (User)usr.get();
            } else {
                user = this.userUtils.getLoggedUser();
            }
            institution.setInstitutionType(request.getInstitutionType());
            institution.setName(request.getName());
            institution.setUser(user);
            institution.setEmail(request.getEmail());
            institution.setNuit(request.getNuit());
            institution.setAddress(request.getAddress());
            institution.setCity(request.getCity());
            institution.setPhone(request.getPhone());
            institution.setSector(request.getSector());
            institution.setRegistrationNumber(request.getRegistrationNumber());
            this.institutionRepository.save((Object)institution);
            return true;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<Institution> getAllInstitution() {
        return this.institutionRepository.findAll();
    }

    public Institution getInstitutionByUser() {
        User user = this.userUtils.getLoggedUser();
        return this.institutionRepository.findByUserId(user.getId());
    }

    public List<UserCompany> getCompanyByUser() {
        User user = this.userUtils.getLoggedUser();
        return this.companyRepository.findByUserId(user.getId());
    }

    public List<UserCompany> allCompany() {
        return this.companyRepository.findAll();
    }

    public Map<String, Object> getCompanyDashboardMatrics(Long id) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        Optional userCompanyOpt = this.companyRepository.findById((Object)id);
        if (userCompanyOpt.isEmpty()) {
            return response;
        }
        UserCompany userCompany = (UserCompany)userCompanyOpt.get();
        List guarantees = this.userGuaranteesRepository.findByApplicantsCompanyId(userCompany.getId());
        long guaranteePendings = guarantees.stream().filter(g -> "PENDING".equalsIgnoreCase(g.getStatus())).count();
        long guaranteeApproved = guarantees.stream().filter(g -> "APPROVED".equalsIgnoreCase(g.getStatus())).count();
        response.put("guarantee_pendings", guaranteePendings);
        response.put("guarantee_approved", guaranteeApproved);
        return response;
    }
}

