/*
 * Decompiled with CFR 0.152.
 */
package com.egarantias.services;

import jakarta.activation.DataSource;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.util.ByteArrayDataSource;
import java.io.UnsupportedEncodingException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Service;

@Service
public class EmailService {
    private final JavaMailSender mailSender;
    @Value(value="${app.frontend.kyc-url}")
    private String kycUrl;

    public EmailService(JavaMailSender mailSender) {
        this.mailSender = mailSender;
    }

    public void sendConfirmationEmail(String to, String token) {
        System.out.println("Start Sen email confirm");
        String subject = "Confirma\u00e7\u00e3o de Conta";
        String confirmationUrl = this.kycUrl + "?token=" + token;
        String content = this.getHtmlContent(confirmationUrl);
        MimeMessage message = this.mailSender.createMimeMessage();
        System.out.println("Start Sen email confirm 1");
        try {
            System.out.println("Start Sen email confirm");
            MimeMessageHelper helper = new MimeMessageHelper(message, true);
            helper.setTo(to);
            helper.setFrom("egarantias@atendimento.co.mz", "eGarantias");
            helper.setSubject(subject);
            helper.setText(content, true);
            this.mailSender.send(message);
        }
        catch (MessagingException | UnsupportedEncodingException e) {
            throw new RuntimeException("Erro ao enviar e-mail", e);
        }
    }

    private String getHtmlContent(String confirmationUrl) {
        return "        <!DOCTYPE html>\n                   <html lang=\"pt\">\n                   <head>\n                       <meta charset=\"UTF-8\">\n                       <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n                       <title>Confirma\u00e7\u00e3o de Conta</title>\n                       <style>\n                           body {\n                               font-family: Arial, sans-serif;\n                               background: #f7f7f7;\n                               margin: 0;\n                               padding: 0;\n                           }\n                           .container {\n                               max-width: 600px;\n                               margin: 30px auto;\n                               background: #fff;\n                               padding: 20px;\n                               border-radius: 8px;\n                               box-shadow: 0 0 10px rgba(0,0,0,0.1);\n                           }\n                           h2 {\n                               color: #333;\n                           }\n                           a.button {\n                               display: inline-block;\n                               padding: 12px 20px;\n                               margin-top: 20px;\n                               background-color: #007bff;\n                               color: white;\n                               text-decoration: none;\n                               border-radius: 5px;\n                           }\n                           .footer {\n                               margin-top: 30px;\n                               font-size: 12px;\n                               color: #777;\n                           }\n                       </style>\n                   </head>\n                   <body>\n                       <div class=\"container\">\n                           <h2>Conta Criada com Sucesso!</h2>\n                           <p>\n                               A sua conta foi registada com sucesso! Para desfrutar de todos os recursos que oferecemos, por favor finalize o preenchimento das suas informa\u00e7\u00f5es adicionais.\n                           </p>\n                           <p>\n                               Basta clicar no bot\u00e3o abaixo para verificar o seu email e completar o processo de valida\u00e7\u00e3o da conta.\n                           </p>\n                           <a href=\"%s\" class=\"button\">Finalizar Cadastro</a>\n                           <div class=\"footer\">\n                               Se voc\u00ea n\u00e3o solicitou esta conta, ignore este e-mail.\n                           </div>\n                       </div>\n                   </body>\n                   </html>\n".formatted(confirmationUrl);
    }

    public void sendCustomEmail(String to, String subject, String content) {
        System.out.println("Start Send Custom email");
        MimeMessage message = this.mailSender.createMimeMessage();
        System.out.println("Start Sen email confirm 1");
        try {
            System.out.println("Start Send email 3");
            MimeMessageHelper helper = new MimeMessageHelper(message, true);
            helper.setTo(to);
            helper.setFrom("egarantias@atendimento.co.mz", "eGarantias");
            helper.setSubject(subject);
            helper.setText(content, true);
            this.mailSender.send(message);
        }
        catch (MessagingException | UnsupportedEncodingException e) {
            throw new RuntimeException("Erro ao enviar e-mail", e);
        }
    }

    public void sendGuaranteeIssuedEmail(String to, String beneficiaryName, String guaranteeType, byte[] pdfBytes) {
        String subject = "Garantia Emitida com Sucesso";
        String content = this.getGuaranteeIssuedHtml(beneficiaryName, guaranteeType);
        MimeMessage message = this.mailSender.createMimeMessage();
        try {
            MimeMessageHelper helper = new MimeMessageHelper(message, true);
            helper.setTo(to);
            helper.setFrom("egarantias@atendimento.co.mz", "eGarantias");
            helper.setSubject(subject);
            helper.setText(content, true);
            if (pdfBytes != null && pdfBytes.length > 0) {
                ByteArrayDataSource dataSource = new ByteArrayDataSource(pdfBytes, "application/pdf");
                helper.addAttachment("Garantia.pdf", (DataSource)dataSource);
            }
            this.mailSender.send(message);
        }
        catch (MessagingException | UnsupportedEncodingException e) {
            throw new RuntimeException("Erro ao enviar e-mail de emiss\u00e3o de garantia", e);
        }
    }

    public void sendErrorNuibEmail(String toEmail, String errorDescription, String oldValue, String newValue) throws MessagingException {
        String htmlBody = this.buildErrorEmailTemplate(errorDescription, oldValue, newValue);
        MimeMessage message = this.mailSender.createMimeMessage();
        MimeMessageHelper helper = new MimeMessageHelper(message, true, "UTF-8");
        helper.setTo(toEmail);
        helper.setSubject("Erro na valida\u00e7\u00e3o dos seus dados");
        helper.setText(htmlBody, true);
        this.mailSender.send(message);
    }

    public void sendSuccessKycEmail(String toEmail, String fullName, String nuib) throws MessagingException {
        String htmlBody = this.buildSuccessEmailTemplate(fullName, nuib);
        MimeMessage message = this.mailSender.createMimeMessage();
        MimeMessageHelper helper = new MimeMessageHelper(message, true, "UTF-8");
        helper.setTo(toEmail);
        helper.setSubject("Dados aprovado com sucesso");
        helper.setText(htmlBody, true);
        this.mailSender.send(message);
    }

    private String getGuaranteeIssuedHtml(String name, String guaranteeType) {
        return "        <!DOCTYPE html>\n        <html lang=\"pt\">\n        <head>\n            <meta charset=\"UTF-8\">\n            <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n            <title>Garantia Emitida</title>\n            <style>\n                body {\n                    font-family: Arial, sans-serif;\n                    background-color: #f4f4f4;\n                    margin: 0;\n                    padding: 0;\n                }\n                .container {\n                    max-width: 600px;\n                    margin: 40px auto;\n                    background: white;\n                    padding: 30px;\n                    border-radius: 8px;\n                    box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);\n                }\n                h2 {\n                    color: #2c3e50;\n                }\n                .footer {\n                    margin-top: 30px;\n                    font-size: 12px;\n                    color: #777;\n                }\n            </style>\n        </head>\n        <body>\n            <div class=\"container\">\n                <h2>Garantia Emitida com Sucesso!</h2>\n                <p>Ol\u00e1 <strong>%s</strong>,</p>\n                <p>Temos o prazer de informar que a garantia do tipo <strong>%s</strong> foi emitida e encontra-se dispon\u00edvel.</p>\n                <p>Voc\u00ea est\u00e1 recebendo este e-mail porque \u00e9 o <strong>benefici\u00e1rio</strong> desta garantia.</p>\n                <p>Em anexo encontrar\u00e1 o documento oficial em formato PDF.</p>\n                <p>Para quaisquer d\u00favidas ou informa\u00e7\u00f5es adicionais, entre em contato com a nossa equipe de atendimento.</p>\n                <div class=\"footer\">\n                    eGarantias &copy; Todos os direitos reservados.\n                </div>\n            </div>\n        </body>\n        </html>\n".formatted(name, guaranteeType);
    }

    public String getGuaranteeExecutionEmailHtml(String executionUrl, String guaranteeRef) {
        return "    <!DOCTYPE html>\n    <html lang=\"pt\">\n    <head>\n        <meta charset=\"UTF-8\">\n        <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n        <title>Execu\u00e7\u00e3o de Garantia</title>\n        <style>\n            body {\n                font-family: Arial, sans-serif;\n                background-color: #f2f2f2;\n                margin: 0;\n                padding: 0;\n            }\n            .container {\n                max-width: 600px;\n                margin: 40px auto;\n                background: #ffffff;\n                padding: 30px;\n                border-radius: 8px;\n                box-shadow: 0 0 15px rgba(0, 0, 0, 0.05);\n            }\n            h2 {\n                color: #333333;\n            }\n            p {\n                color: #555555;\n                line-height: 1.6;\n            }\n            .button {\n                display: inline-block;\n                margin-top: 20px;\n                padding: 12px 25px;\n                background-color: #007bff;\n                color: white;\n                text-decoration: none;\n                border-radius: 5px;\n                font-weight: bold;\n            }\n            .footer {\n                margin-top: 30px;\n                font-size: 12px;\n                color: #999999;\n                text-align: center;\n            }\n        </style>\n    </head>\n    <body>\n        <div class=\"container\">\n            <h2>Solicita\u00e7\u00e3o de Execu\u00e7\u00e3o de Garantia</h2>\n            <p>\n                Recebemos uma solicita\u00e7\u00e3o de execu\u00e7\u00e3o referente \u00e0 garantia com refer\u00eancia:\n                <strong>%s</strong>.\n            </p>\n            <p>\n                Para confirmar esta execu\u00e7\u00e3o, clique no bot\u00e3o abaixo. Este link \u00e9 v\u00e1lido por apenas <strong>15 minutos</strong>.\n            </p>\n            <a href=\"%s\" class=\"button\">Confirmar Execu\u00e7\u00e3o da Garantia</a>\n            <p class=\"footer\">\n                Se voc\u00ea n\u00e3o reconhece esta solicita\u00e7\u00e3o, por favor ignore este e-mail. Nenhuma a\u00e7\u00e3o ser\u00e1 tomada sem sua confirma\u00e7\u00e3o.\n            </p>\n        </div>\n    </body>\n    </html>\n".formatted(guaranteeRef, executionUrl);
    }

    public String getGuaranteeExecutedEmailHtml(String guaranteeRef, String executionTime, String beneficiaryName, String beneficiaryEmail) {
        return "    <!DOCTYPE html>\n    <html lang=\"pt\">\n    <head>\n        <meta charset=\"UTF-8\">\n        <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n        <title>Garantia Executada</title>\n        <style>\n            body {\n                font-family: Arial, sans-serif;\n                background-color: #f2f2f2;\n                margin: 0;\n                padding: 0;\n            }\n            .container {\n                max-width: 600px;\n                margin: 40px auto;\n                background: #ffffff;\n                padding: 30px;\n                border-radius: 8px;\n                box-shadow: 0 0 15px rgba(0, 0, 0, 0.05);\n            }\n            h2 {\n                color: #333333;\n            }\n            p {\n                color: #555555;\n                line-height: 1.6;\n            }\n            .footer {\n                margin-top: 30px;\n                font-size: 12px;\n                color: #999999;\n                text-align: center;\n            }\n        </style>\n    </head>\n    <body>\n        <div class=\"container\">\n            <h2>Garantia Executada com Sucesso</h2>\n            <p>\n                Informamos que a garantia com a refer\u00eancia <strong>%s</strong> foi executada com sucesso no dia <strong>%s</strong>.\n            </p>\n            <p>\n                A execu\u00e7\u00e3o foi realizada pelo benefici\u00e1rio da garantia:\n            </p>\n            <ul>\n                <li><strong>Nome da Institui\u00e7\u00e3o:</strong> %s</li>\n                <li><strong>Email:</strong> %s</li>\n            </ul>\n            <p>\n                Caso n\u00e3o reconhe\u00e7a esta opera\u00e7\u00e3o ou tenha alguma d\u00favida, entre em contato imediatamente com a nossa equipe de suporte.\n            </p>\n            <p class=\"footer\">\n                Esta \u00e9 uma mensagem autom\u00e1tica. Por favor, n\u00e3o responda a este e-mail.\n            </p>\n        </div>\n    </body>\n    </html>\n".formatted(guaranteeRef, executionTime, beneficiaryName, beneficiaryEmail);
    }

    public String buildErrorEmailTemplate(String errorDescription, String oldValue, String newValue) {
        return "<!DOCTYPE html>\n<html lang=\"pt\">\n<head>\n    <meta charset=\"UTF-8\" />\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\" />\n    <title>Erro na Valida\u00e7\u00e3o KYC</title>\n    <style>\n        body { font-family: Arial, sans-serif; background: #f7f7f7; margin: 0; padding: 0; }\n        .container {\n            max-width: 600px; margin: 30px auto; background: #fff;\n            padding: 20px; border-radius: 8px; box-shadow: 0 0 10px rgba(0,0,0,0.1);\n        }\n        h2 { color: #c0392b; }\n        p { color: #333; }\n        .footer { margin-top: 30px; font-size: 12px; color: #777; }\n        .highlight {\n            background-color: #fdecea;\n            border: 1px solid #e74c3c;\n            padding: 10px;\n            border-radius: 4px;\n            margin: 15px 0;\n            color: #e74c3c;\n        }\n    </style>\n</head>\n<body>\n    <div class=\"container\">\n        <h2>Erro na Valida\u00e7\u00e3o dos Seus Dados</h2>\n        <p>Detectamos o seguinte problema com as informa\u00e7\u00f5es enviadas:</p>\n        <div class=\"highlight\">%s</div>\n        <p><strong>Valor antigo:</strong> %s</p>\n        <p><strong>Valor novo:</strong> %s</p>\n        <p>Por favor, atualize os seus dados para prosseguir com a valida\u00e7\u00e3o.</p>\n        <div class=\"footer\">\n            Se voc\u00ea n\u00e3o reconhece esta mensagem, por favor entre em contato com o suporte.\n        </div>\n    </div>\n</body>\n</html>\n".formatted(errorDescription, oldValue, newValue);
    }

    public String buildSuccessEmailTemplate(String fullName, String nuib) {
        return "<!DOCTYPE html>\n<html lang=\"pt\">\n<head>\n    <meta charset=\"UTF-8\" />\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\" />\n    <title>KYC Aprovado</title>\n    <style>\n        body { font-family: Arial, sans-serif; background: #f7f7f7; margin: 0; padding: 0; }\n        .container {\n            max-width: 600px; margin: 30px auto; background: #fff;\n            padding: 20px; border-radius: 8px; box-shadow: 0 0 10px rgba(0,0,0,0.1);\n        }\n        h2 { color: #27ae60; }\n        p { color: #333; }\n        .nuib-box {\n            background-color: #dff0d8;\n            border: 1px solid #3c763d;\n            padding: 15px;\n            border-radius: 5px;\n            font-weight: bold;\n            margin: 15px 0;\n            font-size: 1.2em;\n            color: #3c763d;\n        }\n        .footer { margin-top: 30px; font-size: 12px; color: #777; }\n    </style>\n</head>\n<body>\n    <div class=\"container\">\n        <h2>Ol\u00e1 %s,</h2>\n        <p>Seus dados foram aprovados com sucesso!</p>\n        <p>Seu n\u00famero de identifica\u00e7\u00e3o tribut\u00e1ria (NUIB) \u00e9:</p>\n        <div class=\"nuib-box\">%s</div>\n        <p>Obrigado por confiar em nossos servi\u00e7os.</p>\n        <div class=\"footer\">\n            Caso tenha d\u00favidas, entre em contato com o suporte.\n        </div>\n    </div>\n</body>\n</html>\n".formatted(fullName, nuib);
    }
}

