/*
 * Decompiled with CFR 0.152.
 */
package com.egarantias.services;

import com.egarantias.dto.AnswerRequestActionDTO;
import com.egarantias.dto.ContractualGuaranteeDocumentsDto;
import com.egarantias.dto.ExecuteGuaranteeDTO;
import com.egarantias.dto.GuaranteeBeneficiaryApprovalMail;
import com.egarantias.dto.GuaranteeCancelDecisionMail;
import com.egarantias.dto.GuaranteeCancelRequestMail;
import com.egarantias.dto.GuaranteeDecisionMail;
import com.egarantias.dto.GuaranteeEditDecisionMail;
import com.egarantias.dto.GuaranteeEditRequestMail;
import com.egarantias.dto.GuaranteeExecutionApprovedMail;
import com.egarantias.dto.GuaranteeExecutionRejectedMail;
import com.egarantias.dto.GuaranteeExecutionRequestMail;
import com.egarantias.dto.GuaranteePaymentControlDTO;
import com.egarantias.dto.GuaranteesDTO;
import com.egarantias.dto.MissingDocumentsRequestDto;
import com.egarantias.dto.RequestGuaranteeActionDTO;
import com.egarantias.dto.ValidateContractualDocDTO;
import com.egarantias.models.BaseDocuments;
import com.egarantias.models.ContractualGuaranteeDocuments;
import com.egarantias.models.Documents;
import com.egarantias.models.ExecuteGuarantee;
import com.egarantias.models.GuaranteeMissingDocument;
import com.egarantias.models.GuaranteePaymentControl;
import com.egarantias.models.GuaranteeRequestAction;
import com.egarantias.models.Institution;
import com.egarantias.models.OTPModel;
import com.egarantias.models.User;
import com.egarantias.models.UserCompany;
import com.egarantias.models.UserGuarantees;
import com.egarantias.services.AdvancedEmailService;
import com.egarantias.services.EmailService;
import com.egarantias.services.EmailServiceCTA;
import com.egarantias.services.PdfGenericServices;
import com.egarantias.services.pdf.ContractualDocs;
import com.egarantias.services.repository.BaseDocumentRepository;
import com.egarantias.services.repository.ContractualGuaranteeDocumentsRepository;
import com.egarantias.services.repository.DocumentRepository;
import com.egarantias.services.repository.ExecuteGuaranteeRepository;
import com.egarantias.services.repository.GuaranteeMissingDocumentRepository;
import com.egarantias.services.repository.GuaranteePaymentControlRepository;
import com.egarantias.services.repository.GuaranteeRequestActionRepository;
import com.egarantias.services.repository.InstitutionRepository;
import com.egarantias.services.repository.OTPRepository;
import com.egarantias.services.repository.UserCompanyRepository;
import com.egarantias.services.repository.UserGuaranteesRepository;
import com.egarantias.services.repository.UserKycRepository;
import com.egarantias.services.repository.UserRepository;
import com.egarantias.utils.MailAddress;
import com.egarantias.utils.SystemUtils;
import com.egarantias.utils.UserUtils;
import jakarta.transaction.Transactional;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class GuaranteesService {
    @Value(value="${app.base-front-url}")
    private String baseUrl;
    private final UserRepository userRepository;
    private final UserGuaranteesRepository userGuaranteesRepository;
    private final UserUtils userUtils;
    private final InstitutionRepository institutionRepository;
    private final BaseDocumentRepository baseDocumentRepository;
    private final ContractualGuaranteeDocumentsRepository contractualGuaranteeDocumentsRepository;
    private final DocumentRepository documentsRepository;
    private final GuaranteeMissingDocumentRepository guaranteeMissingDocumentRepository;
    private final UserCompanyRepository userCompanyRepository;
    private final GuaranteePaymentControlRepository guaranteePaymentControlRepository;
    private final EmailService emailService;
    private final UserKycRepository userKycRepository;
    private final OTPRepository otpRepository;
    private final ExecuteGuaranteeRepository executeGuaranteeRepository;
    private final GuaranteeRequestActionRepository guaranteeRequestActionRepository;
    private final AdvancedEmailService advancedEmailService;

    public GuaranteesService(UserRepository userRepository, UserGuaranteesRepository userGuaranteesRepository, DocumentRepository documentRepository, InstitutionRepository institutionRepository, UserUtils userUtils, BaseDocumentRepository baseDocumentRepository, ContractualGuaranteeDocumentsRepository contractualGuaranteeDocumentsRepository, DocumentRepository documentsRepository, GuaranteeMissingDocumentRepository guaranteeMissingDocumentRepository, UserCompanyRepository userCompanyRepository, GuaranteePaymentControlRepository guaranteePaymentControlRepository, EmailService emailService, UserKycRepository userKycRepository, OTPRepository otpRepository, ExecuteGuaranteeRepository executeGuaranteeRepository, GuaranteeRequestActionRepository guaranteeRequestActionRepository, EmailServiceCTA emailServiceCTA, AdvancedEmailService advancedEmailService) {
        this.userUtils = userUtils;
        this.userGuaranteesRepository = userGuaranteesRepository;
        this.userRepository = userRepository;
        this.institutionRepository = institutionRepository;
        this.baseDocumentRepository = baseDocumentRepository;
        this.contractualGuaranteeDocumentsRepository = contractualGuaranteeDocumentsRepository;
        this.documentsRepository = documentsRepository;
        this.guaranteeMissingDocumentRepository = guaranteeMissingDocumentRepository;
        this.userCompanyRepository = userCompanyRepository;
        this.guaranteePaymentControlRepository = guaranteePaymentControlRepository;
        this.emailService = emailService;
        this.userKycRepository = userKycRepository;
        this.otpRepository = otpRepository;
        this.executeGuaranteeRepository = executeGuaranteeRepository;
        this.guaranteeRequestActionRepository = guaranteeRequestActionRepository;
        this.advancedEmailService = advancedEmailService;
    }

    public boolean registerGuaranteesRequest(GuaranteesDTO request) {
        try {
            UserGuarantees guarantees = new UserGuarantees();
            User user = this.userUtils.getLoggedUser();
            System.out.println("Loged user " + String.valueOf(user));
            guarantees.setUser(user);
            guarantees.setInstitution((Institution)this.institutionRepository.findById((Object)request.getInstitutionId()).orElseThrow(() -> new RuntimeException("Institui\u00e7\u00e3o n\u00e3o encontrado")));
            guarantees.setGuaranteeType(request.getGuaranteeType());
            guarantees.setApplicantsCompany((UserCompany)this.userCompanyRepository.findById((Object)request.getApplicantsCompanyId()).orElseThrow(() -> new RuntimeException("Company n\u00e3o encontrado")));
            guarantees.setDescription(request.getDescription());
            guarantees.setGuaranteePrice(request.getGuaranteePrice());
            guarantees.setProjectName(request.getProjectName());
            guarantees.setGuaranteeDurationMonth(request.getGuaranteeDurationMonth());
            guarantees.setBeneficiaryInstitution(request.getBeneficiaryInstitution());
            guarantees.setBeneficiaryInstitutionEmail(request.getBeneficiaryInstitutionEmail());
            guarantees.setContestNumber(request.getContestNumber());
            if (request.getGuaranteeStartDate() != null && !request.getGuaranteeStartDate().isEmpty()) {
                guarantees.setGuaranteeStartDate(LocalDate.parse(request.getGuaranteeStartDate()));
            }
            if (request.getGuaranteeEndDate() != null && !request.getGuaranteeEndDate().isEmpty()) {
                guarantees.setGuaranteeEndDate(LocalDate.parse(request.getGuaranteeEndDate()));
            }
            guarantees.setBeneficiaryPhone(request.getBeneficiaryPhone());
            guarantees.setStatus("PENDING");
            List<Documents> documents = request.getDocuments().stream().map(docDto -> {
                Documents doc = new Documents();
                doc.setName(docDto.getName());
                doc.setFileType(docDto.getFileType());
                doc.setFile(Base64.getDecoder().decode(docDto.getFile()));
                doc.setGuarantees(guarantees);
                return doc;
            }).toList();
            guarantees.setDocuments(documents);
            this.userGuaranteesRepository.save((Object)guarantees);
            return true;
        }
        catch (Exception e) {
            System.out.println("Nao foi possivel concluir a sua operacoa " + String.valueOf(e));
            return false;
        }
    }

    @Transactional
    public List<UserGuarantees> allGuaranteesByUser() {
        User user = this.userUtils.getLoggedUser();
        return this.userGuaranteesRepository.findByUserId(user.getId());
    }

    @Transactional
    public List<UserGuarantees> allGuaranteesByInstitution() {
        User user = this.userUtils.getLoggedUser();
        Institution institution = this.institutionRepository.findByUserId(user.getId());
        if (institution == null) {
            return List.of();
        }
        return this.userGuaranteesRepository.findByInstitutionIdOrderByIdDesc(institution.getId());
    }

    @Transactional
    public List<UserGuarantees> allGuaranteesByCompany(Long id) {
        return this.userGuaranteesRepository.findByApplicantsCompanyIdOrderByIdDesc(id);
    }

    @Transactional
    public UserGuarantees getGuaranteesById(Long id) {
        return (UserGuarantees)this.userGuaranteesRepository.findById((Object)id).orElseThrow(() -> new RuntimeException("Garantia nao encontrada!"));
    }

    @Transactional
    public boolean addContractualDocs(ContractualGuaranteeDocumentsDto dto) throws Exception {
        try {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd 'de' MMMM 'de' yyyy", new Locale("pt", "MZ"));
            ContractualDocs docService = new ContractualDocs();
            User user = this.userUtils.getLoggedUser();
            UserGuarantees guarantee = (UserGuarantees)this.userGuaranteesRepository.findById((Object)dto.getGuarantee_id()).orElseThrow(() -> new RuntimeException("Guarantee not found"));
            for (MissingDocumentsRequestDto.MissingDocDto doc : dto.getRequested_documents()) {
                GuaranteeMissingDocument missing = new GuaranteeMissingDocument();
                missing.setName(doc.getName());
                missing.setDescription(doc.getDescription());
                missing.setGuarantee(guarantee);
                missing.setUploaded(false);
                this.guaranteeMissingDocumentRepository.save((Object)missing);
            }
            ContractualGuaranteeDocuments record = new ContractualGuaranteeDocuments();
            record.setRequestType(dto.getRequest_type());
            record.setGuaranteeFee(dto.getGuarantee_fee());
            record.setGuarantee(guarantee);
            record.setContractualDocSubmitted(false);
            record.setContractualDocApproved(false);
            ArrayList<BaseDocuments> contractFiles = new ArrayList<BaseDocuments>();
            BaseDocuments technicalProposal = new BaseDocuments();
            technicalProposal.setName("Carta Conforto");
            technicalProposal.setFileType("application/pdf");
            System.out.println("Gerando Carta conrto");
            technicalProposal.setFile(PdfGenericServices.generatePdfFromHtml((String)docService.generateComfortLetterHtml(guarantee.getInstitution().getName(), guarantee.getInstitution().getAddress(), guarantee.getInstitution().getCity(), guarantee.getProjectName(), guarantee.getApplicantsCompany().getUser().getFullName(), guarantee.getApplicantsCompany().getAddress(), guarantee.getApplicantsCompany().getCity(), guarantee.getGuaranteePrice().toString(), SystemUtils.convertDecimalToWords((BigDecimal)guarantee.getGuaranteePrice()), guarantee.getDescription(), guarantee.getApplicantsCompany().getCity(), guarantee.getCreatedAt().format(formatter))));
            BaseDocuments financialProposal = new BaseDocuments();
            financialProposal.setName("Contrato de garantia");
            financialProposal.setFileType("application/pdf");
            System.out.println("Gerando Contrato de garanti");
            financialProposal.setFile(PdfGenericServices.generatePdfFromHtml((String)docService.generateWarrantyContractHtml(user)));
            contractFiles.add(technicalProposal);
            contractFiles.add(financialProposal);
            record.setContractFiles(contractFiles);
            record.setContractFiles(contractFiles);
            guarantee.setStatus("INPROGRESS");
            this.userGuaranteesRepository.save((Object)guarantee);
            this.contractualGuaranteeDocumentsRepository.save((Object)record);
            return true;
        }
        catch (Exception e) {
            System.out.println("FALHA AO SALVAR DOCUMENTOS CONTRACTUAIS " + String.valueOf(e));
            return false;
        }
    }

    @Transactional
    public ContractualGuaranteeDocuments getContractualGuaranteeDocuments(Long id) {
        return this.contractualGuaranteeDocumentsRepository.findByGuaranteeId(id);
    }

    public Documents getGuaranteeDocById(Long id) {
        return (Documents)this.documentsRepository.findById((Object)id).orElseThrow(() -> new RuntimeException("Documento n\u00e3o encontrado : " + id));
    }

    public BaseDocuments getGuaranteeBaseDocById(Long id) {
        return (BaseDocuments)this.baseDocumentRepository.findById((Object)id).orElseThrow(() -> new RuntimeException("Documento n\u00e3o encontrado : " + id));
    }

    @Transactional
    public boolean saveMissingDocuments(MissingDocumentsRequestDto dto) {
        try {
            UserGuarantees guarantee = (UserGuarantees)this.userGuaranteesRepository.findById((Object)dto.getGuarantee_id()).orElseThrow(() -> new RuntimeException("Garantia n\u00e3o encontrada"));
            if (dto.getMissing_doc_id() == null) {
                Documents doc = new Documents();
                doc.setName(dto.getDocument_name());
                doc.setFileType(dto.getFile_type());
                doc.setFile(Base64.getDecoder().decode(dto.getFile()));
                doc.setGuarantees(guarantee);
                ArrayList<Documents> docs = guarantee.getDocuments();
                if (docs == null) {
                    docs = new ArrayList<Documents>();
                }
                docs.add(doc);
                guarantee.setDocuments(docs);
                guarantee.setContractSubmitted(true);
                this.userGuaranteesRepository.save((Object)guarantee);
            } else if (Boolean.TRUE.equals(dto.getIs_update())) {
                GuaranteeMissingDocument missingDocument = (GuaranteeMissingDocument)this.guaranteeMissingDocumentRepository.findById((Object)dto.getMissing_doc_id()).orElseThrow(() -> new RuntimeException("Missing Doc n\u00e3o encontrada"));
                Documents doc = new Documents();
                doc.setName(dto.getDocument_name());
                doc.setFileType(dto.getFile_type());
                doc.setFile(Base64.getDecoder().decode(dto.getFile()));
                doc.setGuarantees(guarantee);
                ArrayList<Documents> docs = guarantee.getDocuments();
                if (docs == null) {
                    docs = new ArrayList<Documents>();
                }
                docs.add(doc);
                guarantee.setDocuments(docs);
                missingDocument.setUploaded(true);
                this.guaranteeMissingDocumentRepository.save((Object)missingDocument);
                this.userGuaranteesRepository.save((Object)guarantee);
            } else {
                for (MissingDocumentsRequestDto.MissingDocDto doc : dto.getDocuments()) {
                    GuaranteeMissingDocument missing = new GuaranteeMissingDocument();
                    missing.setName(doc.getName());
                    missing.setDescription(doc.getDescription());
                    missing.setGuarantee(guarantee);
                    missing.setUploaded(false);
                    this.guaranteeMissingDocumentRepository.save((Object)missing);
                }
            }
            return true;
        }
        catch (Exception e) {
            System.out.println("Falha ao salvar MISSING DOCS" + String.valueOf(e));
            return false;
        }
    }

    @Transactional
    public List<GuaranteeMissingDocument> listMissingDocuments(Long id) {
        List<GuaranteeMissingDocument> docs = this.guaranteeMissingDocumentRepository.findByGuaranteeId(id);
        boolean allUploaded = docs.stream().allMatch(GuaranteeMissingDocument::isUploaded);
        if (allUploaded) {
            docs = Collections.emptyList();
        }
        return docs;
    }

    @Transactional
    public boolean saveGuaranteeFile(MissingDocumentsRequestDto dto) {
        try {
            UserGuarantees guarantee = (UserGuarantees)this.userGuaranteesRepository.findById((Object)dto.getGuarantee_id()).orElseThrow(() -> new RuntimeException("Garantia n\u00e3o encontrada"));
            String ref = SystemUtils.generateReference();
            byte[] fileWithFooter = PdfGenericServices.addFooterWithQr((byte[])Base64.getDecoder().decode(dto.getFile()), (String)ref, (String)"http://egarantias.co.mz/cerificate/");
            Documents doc = new Documents();
            doc.setName(dto.getDocument_name());
            doc.setFileType(dto.getFile_type());
            doc.setFile(fileWithFooter);
            doc.setGuarantees(guarantee);
            this.documentsRepository.save((Object)doc);
            guarantee.setGuaranteeFile(doc);
            guarantee.setRef(ref);
            guarantee.setInsurerRef(dto.getInsurerReference());
            guarantee.setStatus("APPROVED");
            this.userGuaranteesRepository.save((Object)guarantee);
            this.emailService.sendGuaranteeIssuedEmail(guarantee.getBeneficiaryInstitutionEmail(), guarantee.getBeneficiaryInstitution(), guarantee.getGuaranteeType(), fileWithFooter);
            return true;
        }
        catch (Exception e) {
            System.out.println("Falha ao salvar Aprovacao de garantia " + String.valueOf(e));
            return false;
        }
    }

    @Transactional
    public boolean rejectGuarantee(AnswerRequestActionDTO dto) {
        UserGuarantees guarantee = (UserGuarantees)this.userGuaranteesRepository.findById((Object)dto.getGuaranteeId()).orElseThrow(() -> new RuntimeException("Garantia n\u00e3o encontrada"));
        if (dto.getStatus().contentEquals("REJECTION")) {
            guarantee.setStatus("REJECTED");
            GuaranteeDecisionMail data = new GuaranteeDecisionMail(guarantee.getId().toString(), guarantee.getRef(), guarantee.getApplicantsCompany().getCompanyName(), guarantee.getInstitution().getName(), OffsetDateTime.now().toLocalDateTime(), guarantee.getCreatedAt().toLocalDate(), dto.getReason(), "", List.of(new MailAddress(guarantee.getApplicantsCompany().getEmail(), guarantee.getApplicantsCompany().getCompanyName())));
            this.userGuaranteesRepository.save((Object)guarantee);
            this.advancedEmailService.sendGuaranteeIssueRejectedMail(data);
            return true;
        }
        return false;
    }

    @Transactional
    public boolean submitContractualFiles(ContractualGuaranteeDocumentsDto dto) {
        try {
            UserGuarantees guarantee = (UserGuarantees)this.userGuaranteesRepository.findById((Object)dto.getGuarantee_id()).orElseThrow(() -> new RuntimeException("Garantia n\u00e3o encontrada"));
            ContractualGuaranteeDocuments contractualGuaranteeDocuments = (ContractualGuaranteeDocuments)this.contractualGuaranteeDocumentsRepository.findById((Object)dto.getContractual_doc_id()).orElseThrow(() -> new RuntimeException("Doc Contratuais n\u00e3o encontrada"));
            List<BaseDocuments> documents = dto.getFiles().stream().map(docDto -> {
                System.out.println("Show Contract docs saved " + docDto.getName());
                BaseDocuments doc = new BaseDocuments();
                doc.setName(docDto.getName());
                doc.setFileType(docDto.getFileType());
                doc.setFile(Base64.getDecoder().decode(docDto.getFile()));
                return doc;
            }).toList();
            List existingDocs = contractualGuaranteeDocuments.getContractFiles();
            contractualGuaranteeDocuments.setContractualDocSubmitted(true);
            existingDocs.addAll(documents);
            guarantee.setContractSubmitted(true);
            this.userGuaranteesRepository.save((Object)guarantee);
            this.contractualGuaranteeDocumentsRepository.save((Object)contractualGuaranteeDocuments);
            return true;
        }
        catch (Exception e) {
            System.out.println("ERRO AO SALVAR submitContractualFiles " + String.valueOf(e));
            return false;
        }
    }

    public void validateContractualDocs(ValidateContractualDocDTO dto) {
        ContractualGuaranteeDocuments contractualGuaranteeDocuments = this.contractualGuaranteeDocumentsRepository.findByGuaranteeId(dto.getGuaranteeId());
        if (dto.getStatus().equalsIgnoreCase("Approved")) {
            contractualGuaranteeDocuments.setContractualDocRejected(false);
            contractualGuaranteeDocuments.setContractualDocApproved(true);
        }
        if (dto.getStatus().equalsIgnoreCase("Rejected")) {
            contractualGuaranteeDocuments.setContractualDocRejected(true);
            contractualGuaranteeDocuments.setContractualDocApproved(false);
            contractualGuaranteeDocuments.setRejectionJustification(dto.getDescription());
        }
        this.contractualGuaranteeDocumentsRepository.save((Object)contractualGuaranteeDocuments);
    }

    public Map<String, Object> makeGuaranteePayment(GuaranteePaymentControlDTO dto) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        GuaranteePaymentControl paymentControl = new GuaranteePaymentControl();
        User user = this.userUtils.getLoggedUser();
        UserGuarantees guarantees = (UserGuarantees)this.userGuaranteesRepository.findById((Object)dto.getGuaranteeId()).orElseThrow(() -> new RuntimeException("Guarantee not found"));
        paymentControl.setPaymentMethod(dto.getPaymentMethod());
        paymentControl.setGuarantee(guarantees);
        paymentControl.setAmount(dto.getAmount());
        paymentControl.setMobileNumber(dto.getMobileNumber());
        paymentControl.setUser(user);
        paymentControl.setWallet(dto.getWallet());
        if (!dto.getProofFile().isEmpty()) {
            ArrayList<BaseDocuments> documents = new ArrayList<BaseDocuments>();
            BaseDocuments doc = new BaseDocuments();
            doc.setName(dto.getProofFileName());
            doc.setFileType(dto.getProofFileType());
            doc.setFile(Base64.getDecoder().decode(dto.getProofFile()));
            documents.add(doc);
            paymentControl.setProofTransferFiles(documents);
        }
        this.guaranteePaymentControlRepository.save((Object)paymentControl);
        response.put("saved", true);
        response.put("message", "Pagamento efectuado com sucesso");
        return response;
    }

    public GuaranteePaymentControl getGuaranteePayment(Long id) {
        Optional guaranteePaymentControl = this.guaranteePaymentControlRepository.findByGuaranteeId(id);
        return guaranteePaymentControl.orElse(null);
    }

    public void executeGuarantee(Long getGuaranteeId) {
        UserGuarantees guarantee = (UserGuarantees)this.userGuaranteesRepository.findById((Object)getGuaranteeId).orElseThrow(() -> new RuntimeException("Garantia n\u00e3o encontrada"));
        String url = this.baseUrl + "/execute/";
        OTPModel otp = OTPModel.create((String)url, (int)72, (Long)guarantee.getId());
        this.otpRepository.save((Object)otp);
        this.emailService.sendCustomEmail(guarantee.getBeneficiaryInstitutionEmail(), "Pedido de execu\u00e7\u00e3o de garantia", this.emailService.getGuaranteeExecutionEmailHtml(otp.getFinalUrl(), guarantee.getRef()));
    }

    public UserGuarantees validateGuaranteeOTP(String otp) {
        Optional otpR = this.otpRepository.findByCode(otp);
        if (otpR.isEmpty()) {
            return null;
        }
        OTPModel otpModel = (OTPModel)otpR.get();
        if (otpModel.isExpired()) {
            return null;
        }
        return (UserGuarantees)this.userGuaranteesRepository.findById((Object)otpModel.getObjectId()).orElseThrow(() -> new RuntimeException("Garantia n\u00e3o encontrada"));
    }

    public void executeGuarantee(ExecuteGuaranteeDTO dto) {
        UserGuarantees guarantees = (UserGuarantees)this.userGuaranteesRepository.findById((Object)dto.getGuaranteeId()).orElseThrow(() -> new RuntimeException("Garantia n\u00e3o encontrada"));
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd 'de' MMMM 'de' yyyy 'pelas' HH:mm", new Locale("pt", "MZ"));
        if (dto.getStatus().contentEquals("REFUSE")) {
            return;
        }
        if (this.executeGuaranteeRepository.findByGuaranteeId(guarantees.getId()).isPresent()) {
            return;
        }
        ExecuteGuarantee executeGuarantee = new ExecuteGuarantee();
        executeGuarantee.setGuaranteeId(guarantees.getId());
        executeGuarantee.setExecuted(false);
        GuaranteeRequestAction guaranteeRequestAction = new GuaranteeRequestAction();
        guaranteeRequestAction.setGuarantee(guarantees);
        guaranteeRequestAction.setRequestType("Request execute");
        guaranteeRequestAction.setRequestedByEmail(guarantees.getBeneficiaryInstitutionEmail());
        guaranteeRequestAction.setRequestedByName(guarantees.getBeneficiaryInstitution());
        this.executeGuaranteeRepository.save((Object)executeGuarantee);
        this.guaranteeRequestActionRepository.save((Object)guaranteeRequestAction);
        GuaranteeExecutionRequestMail data = new GuaranteeExecutionRequestMail(guarantees.getId().toString(), guarantees.getRef(), guarantees.getBeneficiaryInstitution(), guarantees.getBeneficiaryInstitutionEmail(), OffsetDateTime.now().toLocalDateTime(), dto.getReason(), List.of(new MailAddress(guarantees.getApplicantsCompany().getEmail(), guarantees.getApplicantsCompany().getCompanyName()), new MailAddress(guarantees.getInstitution().getEmail(), guarantees.getInstitution().getName())), null);
        this.advancedEmailService.sendGuaranteeExecutionRequest(data);
    }

    @Transactional
    public void requestGuaranteeAction(RequestGuaranteeActionDTO dto) {
        GuaranteeCancelRequestMail data;
        UserGuarantees guarantees = (UserGuarantees)this.userGuaranteesRepository.findById((Object)dto.getGuaranteeId()).orElseThrow(() -> new RuntimeException("Garantia n\u00e3o encontrada"));
        GuaranteeRequestAction guaranteeRequestAction = new GuaranteeRequestAction();
        User user = this.userUtils.getLoggedUser();
        guaranteeRequestAction.setGuarantee(guarantees);
        guaranteeRequestAction.setRequestType(dto.getRequestType());
        guaranteeRequestAction.setRequestedByEmail(user.getEmail());
        guaranteeRequestAction.setRequestedByName(user.getFullName());
        if (dto.getRequestType().contentEquals("Request edit")) {
            if (dto.getAmount().signum() > 0) {
                guaranteeRequestAction.setNewAmount(dto.getAmount());
            }
            if (StringUtils.hasText((CharSequence)dto.getDescription())) {
                guaranteeRequestAction.setNewDescription(dto.getDescription());
            }
            if (StringUtils.hasText((CharSequence)dto.getDuration())) {
                guaranteeRequestAction.setNewDuration(dto.getDuration());
            }
            if (!dto.getDocuments().isEmpty()) {
                List<BaseDocuments> documents = dto.getDocuments().stream().map(docDto -> {
                    BaseDocuments doc = new BaseDocuments();
                    doc.setName(docDto.getName());
                    doc.setFileType(docDto.getFileType());
                    doc.setFile(Base64.getDecoder().decode(docDto.getFile()));
                    return doc;
                }).toList();
                guaranteeRequestAction.setDocuments(documents);
            }
        }
        if (dto.getRequestType().contentEquals("Request cancel")) {
            guaranteeRequestAction.setReason(dto.getReason());
            String url = this.baseUrl + "/cancel/" + guarantees.getId() + "/";
            OTPModel otp = OTPModel.create((String)url, (int)72, (Long)guarantees.getId());
            this.otpRepository.save((Object)otp);
            GuaranteeBeneficiaryApprovalMail data2 = new GuaranteeBeneficiaryApprovalMail(dto.getGuaranteeId().toString(), guarantees.getRef(), guarantees.getBeneficiaryInstitution(), guarantees.getBeneficiaryInstitutionEmail(), guaranteeRequestAction.getRequestedByName(), guaranteeRequestAction.getRequestedByEmail(), OffsetDateTime.now().toLocalDateTime(), null, List.of(new MailAddress(guarantees.getBeneficiaryInstitutionEmail(), guarantees.getBeneficiaryInstitution())), otp.getFinalUrl(), "", null);
            this.advancedEmailService.sendBeneficiaryApprovalRequest(data2);
        }
        this.guaranteeRequestActionRepository.save((Object)guaranteeRequestAction);
        if (dto.getRequestType().contentEquals("Request edit")) {
            data = new GuaranteeEditRequestMail(dto.getGuaranteeId().toString(), guarantees.getRef(), guaranteeRequestAction.getRequestedByName(), guaranteeRequestAction.getRequestedByEmail(), OffsetDateTime.now(), Map.of("Valor da Garantia", Map.of("from", guarantees.getGuaranteePrice(), "to", guaranteeRequestAction.getNewAmount()), "Dura\u00e7\u00e3o (meses)", Map.of("from", guarantees.getGuaranteeDurationMonth(), "to", guaranteeRequestAction.getNewDuration())), List.of(new MailAddress(guarantees.getBeneficiaryInstitutionEmail(), guarantees.getBeneficiaryInstitution()), new MailAddress(guarantees.getInstitution().getEmail(), guarantees.getInstitution().getName())), null);
            this.advancedEmailService.sendGuaranteeEditRequest((GuaranteeEditRequestMail)data);
        }
        if (dto.getRequestType().contentEquals("Request cancel")) {
            data = new GuaranteeCancelRequestMail(dto.getGuaranteeId().toString(), guarantees.getRef(), guaranteeRequestAction.getRequestedByName(), guaranteeRequestAction.getRequestedByEmail(), OffsetDateTime.now().toLocalDateTime(), guaranteeRequestAction.getReason(), List.of(new MailAddress(guarantees.getBeneficiaryInstitutionEmail(), guarantees.getBeneficiaryInstitution()), new MailAddress(guarantees.getInstitution().getEmail(), guarantees.getInstitution().getName())), null);
            this.advancedEmailService.sendGuaranteeCancelRequest(data);
        }
    }

    public List<GuaranteeRequestAction> getRequestActionByGuarantee(Long id) {
        UserGuarantees guarantees = (UserGuarantees)this.userGuaranteesRepository.findById((Object)id).orElseThrow(() -> new RuntimeException("Garantia n\u00e3o encontrada"));
        return this.guaranteeRequestActionRepository.findByGuaranteeIdAndStatus(guarantees.getId(), "PENDING");
    }

    public Optional<GuaranteeRequestAction> getRequestAction(Long id) {
        return this.guaranteeRequestActionRepository.findById((Object)id);
    }

    public GuaranteeRequestAction getRequestActionByGuaranteeId(Long id) {
        UserGuarantees guarantees = (UserGuarantees)this.userGuaranteesRepository.findById((Object)id).orElseThrow(() -> new RuntimeException("Garantia n\u00e3o encontrada"));
        return this.guaranteeRequestActionRepository.findByGuarantee_IdAndRequestTypeAndStatus(guarantees.getId(), "Request cancel", "PENDING");
    }

    public boolean answerRequestAction(AnswerRequestActionDTO dto) {
        Optional guaranteeRequestActionIns = this.guaranteeRequestActionRepository.findById((Object)dto.getRequestActionId());
        if (guaranteeRequestActionIns.isEmpty()) {
            return false;
        }
        GuaranteeRequestAction guaranteeRequestAction = (GuaranteeRequestAction)guaranteeRequestActionIns.get();
        UserGuarantees guarantees = (UserGuarantees)this.userGuaranteesRepository.findById((Object)guaranteeRequestAction.getGuarantee().getId()).orElseThrow(() -> new RuntimeException("Garantia n\u00e3o encontrada"));
        if (dto.getStatus().contentEquals("REJECTED")) {
            GuaranteeEditDecisionMail data;
            guaranteeRequestAction.setStatus(dto.getStatus());
            this.guaranteeRequestActionRepository.save((Object)guaranteeRequestAction);
            if (guaranteeRequestAction.getRequestType().contentEquals("Request edit")) {
                data = new GuaranteeEditDecisionMail(guarantees.getId().toString(), guarantees.getRef(), false, guarantees.getInstitution().getName(), OffsetDateTime.now().toLocalDateTime(), "", List.of(new MailAddress(guarantees.getBeneficiaryInstitutionEmail(), guarantees.getBeneficiaryInstitution()), new MailAddress(guarantees.getApplicantsCompany().getEmail(), guarantees.getApplicantsCompany().getCompanyName())), null);
                this.advancedEmailService.sendGuaranteeEditDecision(data);
            }
            if (guaranteeRequestAction.getRequestType().contentEquals("Request cancel")) {
                data = new GuaranteeCancelDecisionMail(guarantees.getId().toString(), guarantees.getRef(), false, guarantees.getInstitution().getName(), OffsetDateTime.now().toLocalDateTime(), guaranteeRequestAction.getReason(), List.of(new MailAddress(guarantees.getBeneficiaryInstitutionEmail(), guarantees.getBeneficiaryInstitution()), new MailAddress(guarantees.getApplicantsCompany().getEmail(), guarantees.getApplicantsCompany().getCompanyName())), null);
                this.advancedEmailService.sendGuaranteeCancelDecision((GuaranteeCancelDecisionMail)data);
            }
            if (guaranteeRequestAction.getRequestType().contentEquals("Request execute")) {
                ExecuteGuarantee executeGuarantee = this.executeGuaranteeRepository.findByGuaranteeIdAndIsExecuted(guarantees.getId(), false);
                executeGuarantee.setExecuted(false);
                executeGuarantee.setExecutedByEmail(guarantees.getInstitution().getEmail());
                this.executeGuaranteeRepository.save((Object)executeGuarantee);
                GuaranteeExecutionRejectedMail data2 = new GuaranteeExecutionRejectedMail(guarantees.getId().toString(), guarantees.getRef(), OffsetDateTime.now().toLocalDateTime(), guarantees.getInstitution().getName(), guaranteeRequestAction.getReason(), List.of(new MailAddress(guarantees.getBeneficiaryInstitutionEmail(), guarantees.getBeneficiaryInstitution()), new MailAddress(guarantees.getApplicantsCompany().getEmail(), guarantees.getApplicantsCompany().getCompanyName())), null);
                this.advancedEmailService.sendGuaranteeExecutionRejected(data2);
            }
            return true;
        }
        if (dto.getStatus().contentEquals("APPROVED")) {
            GuaranteeCancelDecisionMail data;
            guaranteeRequestAction.setStatus(dto.getStatus());
            if (guaranteeRequestAction.getRequestType().contentEquals("Request edit")) {
                if (guaranteeRequestAction.getNewAmount().signum() > 0) {
                    guaranteeRequestAction.setOldAmount(guarantees.getGuaranteePrice());
                    guarantees.setGuaranteePrice(guaranteeRequestAction.getNewAmount());
                }
                if (StringUtils.hasText((CharSequence)guaranteeRequestAction.getNewDescription())) {
                    guaranteeRequestAction.setOldDescription(guarantees.getDescription());
                    guarantees.setDescription(guaranteeRequestAction.getNewDescription());
                }
                if (StringUtils.hasText((CharSequence)guaranteeRequestAction.getNewDuration())) {
                    guaranteeRequestAction.setOldDuration(guarantees.getGuaranteeDurationMonth());
                    guarantees.setGuaranteeDurationMonth(guaranteeRequestAction.getNewDuration());
                }
                if (!guaranteeRequestAction.getDocuments().isEmpty()) {
                    List<Documents> documents = guaranteeRequestAction.getDocuments().stream().map(docDto -> {
                        Documents doc = new Documents();
                        doc.setName(docDto.getName());
                        doc.setFileType(docDto.getFileType());
                        doc.setFile(Base64.getDecoder().decode(docDto.getFile()));
                        doc.setGuarantees(guarantees);
                        return doc;
                    }).toList();
                    guarantees.getDocuments().addAll(documents);
                }
                data = new GuaranteeEditDecisionMail(guarantees.getId().toString(), guarantees.getRef(), true, guarantees.getInstitution().getName(), OffsetDateTime.now().toLocalDateTime(), "", List.of(new MailAddress(guarantees.getBeneficiaryInstitutionEmail(), guarantees.getBeneficiaryInstitution()), new MailAddress(guarantees.getApplicantsCompany().getEmail(), guarantees.getApplicantsCompany().getCompanyName())), null);
                this.advancedEmailService.sendGuaranteeEditDecision((GuaranteeEditDecisionMail)data);
            }
            if (guaranteeRequestAction.getRequestType().contentEquals("Request cancel")) {
                guarantees.setStatus("CANCELED");
                data = new GuaranteeCancelDecisionMail(guarantees.getId().toString(), guarantees.getRef(), true, guarantees.getInstitution().getName(), OffsetDateTime.now().toLocalDateTime(), "", List.of(new MailAddress(guarantees.getBeneficiaryInstitutionEmail(), guarantees.getBeneficiaryInstitution()), new MailAddress(guarantees.getApplicantsCompany().getEmail(), guarantees.getApplicantsCompany().getCompanyName())), null);
                this.advancedEmailService.sendGuaranteeCancelDecision(data);
            }
            if (guaranteeRequestAction.getRequestType().contentEquals("Request execute")) {
                guarantees.setStatus("EXECUTED");
                ExecuteGuarantee executeGuarantee = this.executeGuaranteeRepository.findByGuaranteeIdAndIsExecuted(guarantees.getId(), false);
                executeGuarantee.setExecuted(true);
                executeGuarantee.setExecutedByEmail(guarantees.getInstitution().getEmail());
                this.executeGuaranteeRepository.save((Object)executeGuarantee);
                GuaranteeExecutionApprovedMail data3 = new GuaranteeExecutionApprovedMail(guarantees.getId().toString(), guarantees.getRef(), OffsetDateTime.now().toLocalDateTime(), List.of(new MailAddress(guarantees.getBeneficiaryInstitutionEmail(), guarantees.getBeneficiaryInstitution()), new MailAddress(guarantees.getApplicantsCompany().getEmail(), guarantees.getApplicantsCompany().getCompanyName())), null);
                this.advancedEmailService.sendGuaranteeExecutionApproved(data3);
            }
            this.userGuaranteesRepository.save((Object)guarantees);
            this.guaranteeRequestActionRepository.save((Object)guaranteeRequestAction);
            return true;
        }
        return false;
    }

    public boolean beneficiary_answer_cancel_request(AnswerRequestActionDTO dto) {
        System.out.println("SHOW ID " + String.valueOf(dto));
        Optional guaranteeRequestActionIns = this.guaranteeRequestActionRepository.findById((Object)dto.getRequestActionId());
        if (guaranteeRequestActionIns.isEmpty()) {
            return false;
        }
        GuaranteeRequestAction guaranteeRequestAction = (GuaranteeRequestAction)guaranteeRequestActionIns.get();
        System.out.println("SHOW ID founded " + guaranteeRequestAction.getGuarantee().getId());
        UserGuarantees guarantees = (UserGuarantees)this.userGuaranteesRepository.findById((Object)guaranteeRequestAction.getGuarantee().getId()).orElseThrow(() -> new RuntimeException("Garantia n\u00e3o encontrada"));
        if (dto.getStatus().contentEquals("REJECTED")) {
            guaranteeRequestAction.setStatus(dto.getStatus());
            GuaranteeCancelDecisionMail data = new GuaranteeCancelDecisionMail(guarantees.getId().toString(), guarantees.getRef(), false, guarantees.getBeneficiaryInstitution(), OffsetDateTime.now().toLocalDateTime(), dto.getReason(), List.of(new MailAddress(guarantees.getInstitution().getEmail(), guarantees.getInstitution().getName()), new MailAddress(guarantees.getApplicantsCompany().getEmail(), guarantees.getApplicantsCompany().getCompanyName())), null);
            this.advancedEmailService.sendGuaranteeCancelDecision(data);
            this.guaranteeRequestActionRepository.save((Object)guaranteeRequestAction);
            return true;
        }
        if (dto.getStatus().contentEquals("APPROVED")) {
            guaranteeRequestAction.setStatus(dto.getStatus());
            guarantees.setStatus("CANCELED");
            GuaranteeCancelDecisionMail data = new GuaranteeCancelDecisionMail(guarantees.getId().toString(), guarantees.getRef(), true, guarantees.getBeneficiaryInstitution(), OffsetDateTime.now().toLocalDateTime(), dto.getReason(), List.of(new MailAddress(guarantees.getInstitution().getEmail(), guarantees.getInstitution().getName()), new MailAddress(guarantees.getApplicantsCompany().getEmail(), guarantees.getApplicantsCompany().getCompanyName())), null);
            this.advancedEmailService.sendGuaranteeCancelDecision(data);
            this.userGuaranteesRepository.save((Object)guarantees);
            this.guaranteeRequestActionRepository.save((Object)guaranteeRequestAction);
            return true;
        }
        return false;
    }
}

