/*
 * Decompiled with CFR 0.152.
 */
package com.egarantias.services;

import com.egarantias.dto.InstitutionSettingsDTO;
import com.egarantias.models.Institution;
import com.egarantias.models.InstitutionSettings;
import com.egarantias.models.User;
import com.egarantias.services.repository.InstitutionRepository;
import com.egarantias.services.repository.InstitutionSettingsRepository;
import com.egarantias.services.repository.UserGuaranteesRepository;
import com.egarantias.utils.UserUtils;
import java.time.YearMonth;
import java.time.format.TextStyle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service
public class InstitutionService {
    private InstitutionSettingsRepository institutionSettingsRepository;
    private InstitutionRepository institutionRepository;
    private final UserUtils userUtils;
    private final UserGuaranteesRepository userGuaranteesRepository;

    public InstitutionService(InstitutionSettingsRepository institutionSettingsRepository, InstitutionRepository institutionRepository, UserUtils userUtils, UserGuaranteesRepository userGuaranteesRepository) {
        this.institutionSettingsRepository = institutionSettingsRepository;
        this.institutionRepository = institutionRepository;
        this.userUtils = userUtils;
        this.userGuaranteesRepository = userGuaranteesRepository;
    }

    public Map<String, Object> createSettings(InstitutionSettingsDTO dto) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        InstitutionSettings institutionSettings = new InstitutionSettings();
        Optional checkInstitution = this.institutionRepository.findById((Object)dto.getInstitutionId());
        if (checkInstitution.isEmpty()) {
            response.put("saved", false);
            response.put("message", "Instituicao nao encontrada");
            return response;
        }
        Institution institution = (Institution)checkInstitution.get();
        institutionSettings.setInstitution(institution);
        institutionSettings.setPercentualTax(dto.getPercentualTax());
        this.institutionSettingsRepository.save((Object)institutionSettings);
        response.put("saved", true);
        response.put("message", "Instituicao configurada");
        return response;
    }

    public InstitutionSettings getSettings(Long id) {
        Optional institutionSettings = this.institutionSettingsRepository.findByInstitutionId(id);
        return institutionSettings.orElse(null);
    }

    public Map<String, Object> getDashboardMetrics() {
        User user = this.userUtils.getLoggedUser();
        Institution institution = this.institutionRepository.findByUserId(user.getId());
        List guarantees = this.userGuaranteesRepository.findByInstitutionId(institution.getId());
        long guaranteePendings = guarantees.stream().filter(g -> "PENDING".equalsIgnoreCase(g.getStatus())).count();
        long guaranteeApproved = guarantees.stream().filter(g -> "APPROVED".equalsIgnoreCase(g.getStatus())).count();
        ArrayList chartData = new ArrayList();
        YearMonth now = YearMonth.now();
        for (int i = 5; i >= 0; --i) {
            YearMonth month = now.minusMonths(i);
            long count = guarantees.stream().filter(g -> g.getCreatedAt() != null && YearMonth.from(g.getCreatedAt().toLocalDate()).equals(month)).count();
            HashMap<String, Object> entry = new HashMap<String, Object>();
            entry.put("name", month.getMonth().getDisplayName(TextStyle.SHORT, Locale.forLanguageTag("pt")));
            entry.put("value", count);
            chartData.add(entry);
        }
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("guarantee_pendings", guaranteePendings);
        response.put("guarantee_approved", guaranteeApproved);
        response.put("guarantee_clients", guaranteeApproved);
        response.put("guarantees", guarantees);
        response.put("chart_data", chartData);
        return response;
    }
}

