/*
 * Decompiled with CFR 0.152.
 */
package com.egarantias.services;

import com.egarantias.models.KycErrorLog;
import com.egarantias.models.UserKyc;
import com.egarantias.services.EmailService;
import com.egarantias.services.repository.KycErrorLogRepository;
import com.egarantias.services.repository.UserKycRepository;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.transaction.Transactional;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class KycVerification {
    @Value(value="${app.bm-token}")
    private String bearerToken;
    @Value(value="${app.bm.base-url}")
    private String baseUrl;
    private final RestTemplate restTemplate = new RestTemplate();
    private final UserKycRepository userKycRepository;
    private final KycErrorLogRepository kycErrorLogRepository;
    private final ObjectMapper objectMapper;
    private final EmailService emailService;

    public KycVerification(UserKycRepository userKycRepository, KycErrorLogRepository kycErrorLogRepository, ObjectMapper objectMapper, EmailService emailService) {
        this.userKycRepository = userKycRepository;
        this.kycErrorLogRepository = kycErrorLogRepository;
        this.objectMapper = objectMapper;
        this.emailService = emailService;
    }

    public ResponseEntity<String> sendUserKyc(UserKyc userKyc, String endpointUrl) {
        HashMap<String, String> payload = new HashMap<String, String>();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd-MM-yyyy");
        payload.put("msg_id", userKyc.getMsgId());
        payload.put("clie_nome", userKyc.getFullName());
        payload.put("clie_nuit", userKyc.getNuit());
        payload.put("clie_resi", userKyc.getIsResident() != false ? "1" : "0");
        payload.put("clie_datn", userKyc.getDateOfBirth().format(formatter));
        payload.put("clie_gene", userKyc.getGender());
        payload.put("clie_nomp", userKyc.getFatherFullName());
        payload.put("clie_nomm", userKyc.getMotherFullName());
        payload.put("clie_tipd", userKyc.getDocType());
        payload.put("clie_nide", userKyc.getDocNumber());
        payload.put("clie_naci", userKyc.getCountryIsoCode());
        payload.put("clie_natu", userKyc.getHometownCode());
        payload.put("clie_loca", userKyc.getLocalityCode());
        payload.put("clie_bair", userKyc.getNeighborhoodName());
        payload.put("clie_ende", userKyc.getAddress());
        payload.put("clie_numr", userKyc.getClientNumber());
        if (userKyc.getDocFrontImg() != null) {
            payload.put("clie_imgf", Base64.getEncoder().encodeToString(userKyc.getDocFrontImg()));
        }
        if (userKyc.getDocBackImg() != null) {
            payload.put("clie_imgb", Base64.getEncoder().encodeToString(userKyc.getDocBackImg()));
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setBearerAuth(this.bearerToken);
        System.out.println("HEARD BM " + String.valueOf(headers));
        HttpEntity requestEntity = new HttpEntity(payload, (MultiValueMap)headers);
        System.out.println("RESPONSE BM " + String.valueOf(requestEntity.getBody()));
        return this.restTemplate.exchange(endpointUrl, HttpMethod.POST, requestEntity, String.class, new Object[0]);
    }

    @Scheduled(fixedRate=600000L)
    @Transactional
    public void verifyPendingKycRequests(String baseUrl) {
        List pendingList = this.userKycRepository.findByVerifiedFalse();
        for (UserKyc kyc : pendingList) {
            try {
                String url = baseUrl + "/nuib/get-response?MessageID=" + kyc.getMsgId();
                ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, null, String.class, new Object[0]);
                if (response.getStatusCode() == HttpStatus.OK) {
                    String body = (String)response.getBody();
                    JsonNode root = this.objectMapper.readTree(body);
                    if (root.has("campos")) {
                        JsonNode campos = root.get("campos");
                        for (JsonNode campo : campos) {
                            String errorCode = campo.get("clie_camp").asText();
                            String campoNome = campo.get("clie_camp").asText();
                            String oldValue = campo.get("clie_iant").asText();
                            String newValue = campo.get("clie_inov").asText();
                            String description = this.translateErrorCode(errorCode);
                            KycErrorLog errorLog = new KycErrorLog();
                            errorLog.setUserKyc(kyc);
                            errorLog.setErrorCode(errorCode);
                            errorLog.setErrorDescription(description + " (Antigo: " + oldValue + ", Novo: " + newValue + ")");
                            errorLog.setCreatedAt(LocalDateTime.now());
                            this.kycErrorLogRepository.save((Object)errorLog);
                            this.emailService.sendErrorNuibEmail(kyc.getUser().getEmail(), description, oldValue, newValue);
                            System.out.printf("Discrep\u00e2ncia no campo %s: antigo=%s novo=%s%n", campoNome, oldValue, newValue);
                        }
                        continue;
                    }
                    if (root.has("clie_nuib")) {
                        String nuib = root.get("clie_nuib").asText();
                        kyc.setNuib(nuib);
                    }
                    kyc.setVerified(true);
                    this.userKycRepository.save((Object)kyc);
                    this.emailService.sendSuccessKycEmail(kyc.getUser().getEmail(), kyc.getFullName(), kyc.getNuib());
                    System.out.println("KYC " + kyc.getMsgId() + " verificado com sucesso.");
                    continue;
                }
                System.err.println("Erro na requisi\u00e7\u00e3o para " + kyc.getMsgId() + " HTTP status: " + String.valueOf(response.getStatusCode()));
            }
            catch (Exception e) {
                System.err.println("Erro ao verificar KYC " + kyc.getMsgId() + ": " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    private String translateErrorCode(String code) {
        return switch (code) {
            case "NUIT" -> "NUIT encontrado com Registo comercial diferente";
            case "DL97" -> "Erro Gen\u00e9rico: Erro de formata\u00e7\u00e3o do ficheiro, valide se o ficheiro fornecido est\u00e1 correto";
            case "DL98" -> "N\u00famero do documento de identifica\u00e7\u00e3o \u00e9 obrigat\u00f3rio";
            case "DL99" -> "NUIT encontrado com Documento de Identifica\u00e7\u00e3o, data de nascimento e g\u00e9nero diferente";
            case "DL01" -> "Formato de C\u00f3digo de Mensagem inv\u00e1lido";
            case "DL70" -> "Imagem submetida n\u00e3o \u00e9 base64 v\u00e1lida";
            case "DL71" -> "Os dados do cliente n\u00e3o foram actualizados";
            case "DL100" -> "N\u00famero de Identifica\u00e7\u00e3o Tribut\u00e1rio estrangeiro \u00e9 obrigat\u00f3rio/inv\u00e1lido";
            case "DL101" -> "Cliente n\u00e3o \u00e9 menor";
            case "DL102" -> "NUIB n\u00e3o encontrado";
            case "DL103" -> "NUIB n\u00e3o pertence \u00e0 institui\u00e7\u00e3o";
            case "DL104" -> "NUIT encontrado com Documento de Identifica\u00e7\u00e3o e g\u00e9nero diferente";
            case "DL105" -> "NUIT encontrado com Documento de Identifica\u00e7\u00e3o e Data de nascimento diferente";
            default -> "Erro desconhecido: " + code;
        };
    }
}

