/*
 * Decompiled with CFR 0.152.
 */
package com.egarantias.services;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Font;
import com.itextpdf.text.Image;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.ColumnText;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfStamper;
import com.itextpdf.text.pdf.PdfWriter;
import com.itextpdf.tool.xml.XMLWorkerHelper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

/*
 * Exception performing whole class analysis ignored.
 */
public class PdfGenericServices {
    public static byte[] addFooterWithQr(byte[] originalPdf, String footerText, String qrContent) throws IOException, DocumentException, WriterException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        PdfReader reader = new PdfReader(originalPdf);
        PdfStamper stamper = new PdfStamper(reader, (OutputStream)outputStream);
        int lastPage = reader.getNumberOfPages();
        Image qrImage = Image.getInstance((byte[])PdfGenericServices.generateQrCode((String)qrContent));
        qrImage.scaleAbsolute(50.0f, 50.0f);
        PdfContentByte canvas = stamper.getOverContent(lastPage);
        Rectangle pageSize = reader.getPageSize(lastPage);
        float centerX = (pageSize.getLeft() + pageSize.getRight()) / 2.0f;
        qrImage.setAbsolutePosition(pageSize.getRight() - 70.0f, pageSize.getBottom() + 20.0f);
        canvas.addImage(qrImage);
        ColumnText.showTextAligned((PdfContentByte)canvas, (int)1, (Phrase)new Phrase(footerText, new Font(Font.FontFamily.HELVETICA, 9.0f, 2, BaseColor.GRAY)), (float)(centerX - 50.0f), (float)(pageSize.getBottom() + 35.0f), (float)0.0f);
        stamper.close();
        reader.close();
        return outputStream.toByteArray();
    }

    private static byte[] generateQrCode(String content) throws WriterException, IOException {
        QRCodeWriter qrCodeWriter = new QRCodeWriter();
        BitMatrix bitMatrix = qrCodeWriter.encode(content, BarcodeFormat.QR_CODE, 150, 150);
        ByteArrayOutputStream pngOutputStream = new ByteArrayOutputStream();
        MatrixToImageWriter.writeToStream((BitMatrix)bitMatrix, (String)"PNG", (OutputStream)pngOutputStream);
        return pngOutputStream.toByteArray();
    }

    public static byte[] generatePdfFromHtml(String htmlContent) throws IOException, DocumentException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Document document = new Document();
        PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)baos);
        document.open();
        XMLWorkerHelper.getInstance().parseXHtml(writer, document, (InputStream)new ByteArrayInputStream(htmlContent.getBytes()));
        document.close();
        return baos.toByteArray();
    }
}

