/*
 * Decompiled with CFR 0.152.
 */
package com.egarantias.services;

import com.egarantias.dto.UserDto;
import com.egarantias.dto.UserKycDto;
import com.egarantias.dto.UserRegistrationRequest;
import com.egarantias.models.User;
import com.egarantias.models.UserGuarantees;
import com.egarantias.models.UserKyc;
import com.egarantias.services.EmailService;
import com.egarantias.services.KycVerification;
import com.egarantias.services.repository.UserGuaranteesRepository;
import com.egarantias.services.repository.UserKycRepository;
import com.egarantias.services.repository.UserRepository;
import com.egarantias.utils.SystemUtils;
import com.egarantias.utils.UserUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;

@Service
public class UserServices {
    private final UserRepository userRepository;
    private final UserKycRepository userKycRepository;
    private final PasswordEncoder passwordEncoder;
    private final EmailService emailService;
    private final UserUtils userUtils;
    private UserGuaranteesRepository userGuaranteesRepository;
    @Autowired
    private KycVerification kycVerification;
    private SystemUtils systemUtils;

    public UserServices(UserRepository userRepository, UserKycRepository userKycRepository, PasswordEncoder passwordEncoder, EmailService emailService, UserUtils userUtils, UserGuaranteesRepository userGuaranteesRepository, KycVerification kycVerification, SystemUtils systemUtils) {
        this.userRepository = userRepository;
        this.userKycRepository = userKycRepository;
        this.passwordEncoder = passwordEncoder;
        this.emailService = emailService;
        this.userUtils = userUtils;
        this.userGuaranteesRepository = userGuaranteesRepository;
        this.kycVerification = kycVerification;
        this.systemUtils = systemUtils;
    }

    public Map<String, Object> createApplicantUser(UserDto request) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        if (this.userRepository.existsByEmail(request.email)) {
            response.put("saved", false);
            response.put("message", "O email j\u00e1 est\u00e1 cadastrado");
            return response;
        }
        if (this.userRepository.existsByUsername(request.username)) {
            response.put("saved", false);
            response.put("message", "O nome de usu\u00e1rio j\u00e1 est\u00e1 cadastrado");
            return response;
        }
        User user = new User();
        user.setUsername(request.username);
        user.setFullName(request.fullName);
        user.setEmail(request.email);
        user.setPhoneNumber(request.phoneNumber);
        user.setPermission(request.permission);
        user.setPassword(this.passwordEncoder.encode((CharSequence)request.password));
        user = (User)this.userRepository.save((Object)user);
        this.emailService.sendConfirmationEmail(user.getEmail(), "");
        response.put("saved", true);
        response.put("message", "Dados salvos com sucesso");
        return response;
    }

    public Map<String, Object> registerUserKyc(UserKycDto request) {
        try {
            HashMap<String, Object> response = new HashMap<String, Object>();
            User user = this.userUtils.getLoggedUser();
            String msgId = this.systemUtils.generateReference(1, "40");
            UserKyc kyc = new UserKyc();
            kyc.setMsgId(msgId);
            kyc.setFullName(request.fullName);
            kyc.setNuit(request.nuit);
            kyc.setIsResident(request.isResident);
            kyc.setDateOfBirth(request.dateOfBirth);
            kyc.setGender(request.gender);
            kyc.setFatherFullName(request.fatherFullName);
            kyc.setMotherFullName(request.motherFullName);
            kyc.setDocType(request.docType);
            kyc.setDocNumber(request.docNumber);
            kyc.setCountryIsoCode(request.countryIsoCode);
            kyc.setLocalityCode(request.localityCode);
            kyc.setHometownCode(request.hometownCode);
            kyc.setNeighborhoodName(request.neighborhoodName);
            kyc.setAddress(request.address);
            kyc.setClientNumber(request.clientNumber);
            kyc.setDocFrontImg(request.docFrontImg);
            kyc.setDocBackImg(request.docBackImg);
            kyc.setUser(user);
            this.userKycRepository.save((Object)kyc);
            this.sendKycTo(kyc);
            response.put("saved", true);
            response.put("message", "Dados salvos com sucesso");
            return response;
        }
        catch (Exception e) {
            HashMap<String, Object> response = new HashMap<String, Object>();
            System.out.println("Fieled to create user kyc " + String.valueOf(e));
            response.put("saved", false);
            response.put("message", "N\u00e3o foi poss\u00edvel cadastrar os seus dados, por favor tente novamente!");
            return response;
        }
    }

    public Map<String, Object> registerUserAndKyc(UserRegistrationRequest request) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        if (this.userRepository.existsByEmail(request.user.email)) {
            response.put("saved", false);
            response.put("message", "O email j\u00e1 est\u00e1 cadastrado");
            return response;
        }
        if (this.userRepository.existsByUsername(request.user.username)) {
            response.put("saved", false);
            response.put("message", "O nome de usu\u00e1rio j\u00e1 est\u00e1 cadastrado");
            return response;
        }
        User user = new User();
        user.setUsername(request.user.username);
        user.setFullName(request.user.fullName);
        user.setEmail(request.user.email);
        user.setPhoneNumber(request.user.phoneNumber);
        user.setPermission(request.user.permission);
        user.setPassword(this.passwordEncoder.encode((CharSequence)request.user.password));
        user = (User)this.userRepository.save((Object)user);
        UserKyc kyc = new UserKyc();
        kyc.setMsgId(request.kyc.msgId);
        kyc.setFullName(request.kyc.fullName);
        kyc.setNuit(request.kyc.nuit);
        kyc.setIsResident(request.kyc.isResident);
        kyc.setDateOfBirth(request.kyc.dateOfBirth);
        kyc.setGender(request.kyc.gender);
        kyc.setFatherFullName(request.kyc.fatherFullName);
        kyc.setMotherFullName(request.kyc.motherFullName);
        kyc.setDocType(request.kyc.docType);
        kyc.setDocNumber(request.kyc.docNumber);
        kyc.setCountryIsoCode(request.kyc.countryIsoCode);
        kyc.setLocalityCode(request.kyc.localityCode);
        kyc.setHometownCode(request.kyc.hometownCode);
        kyc.setNeighborhoodName(request.kyc.neighborhoodName);
        kyc.setAddress(request.kyc.address);
        kyc.setClientNumber(request.kyc.clientNumber);
        kyc.setDocFrontImg(request.kyc.docFrontImg);
        kyc.setDocBackImg(request.kyc.docBackImg);
        this.userKycRepository.save((Object)kyc);
        response.put("saved", true);
        response.put("message", "Dados salvos com sucesso");
        return response;
    }

    public Map<String, Object> verifyUserKyc() {
        User user = this.userUtils.getLoggedUser();
        HashMap<String, Object> response = new HashMap<String, Object>();
        Optional userKyc = this.userKycRepository.findByUserId(user.getId());
        if (userKyc.isPresent()) {
            UserKyc kyc = (UserKyc)userKyc.get();
            response.put("created", true);
            response.put("verified", kyc.isVerified());
            return response;
        }
        response.put("created", false);
        return response;
    }

    public UserGuarantees verifyGuaranteeRef(String ref) {
        Optional userGuarantees = this.userGuaranteesRepository.findByRef(ref);
        return userGuarantees.orElse(null);
    }

    public void sendKycTo(UserKyc kyc) {
        String url = "https://bmapi-qas.bancomoc.mz//nuib/request-colectivo";
        ResponseEntity response = this.kycVerification.sendUserKyc(kyc, url);
        if (response.getStatusCode().is2xxSuccessful()) {
            System.out.println("KYC enviado com sucesso: " + (String)response.getBody());
        } else {
            System.err.println("Erro ao enviar KYC: " + String.valueOf(response.getStatusCode()));
        }
    }
}

