/*
 * Decompiled with CFR 0.152.
 */
package com.egarantias.services.jwt;

import com.egarantias.services.repository.UserRepository;
import com.egarantias.utils.Jwt;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Collections;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.WebAuthenticationDetailsSource;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;

@Component
public class JwtRequestAuth
extends OncePerRequestFilter {
    private final Jwt jwtUtil;
    private final UserRepository userRepository;

    public JwtRequestAuth(Jwt jwtUtil, UserRepository userRepository) {
        this.jwtUtil = jwtUtil;
        this.userRepository = userRepository;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String username;
        block6: {
            String authHeader = request.getHeader("Authorization");
            username = null;
            String jwt = null;
            if (authHeader != null && authHeader.startsWith("Bearer ")) {
                jwt = authHeader.substring(7);
                System.out.println("Start validate jwt " + jwt);
                try {
                    if (this.jwtUtil.validateToken(jwt)) {
                        username = this.jwtUtil.extractUsername(jwt);
                        break block6;
                    }
                    System.out.println("Token JWT inv\u00e1lido");
                }
                catch (Exception e) {
                    System.out.println("Erro ao validar token JWT: " + e.getMessage());
                }
            } else {
                System.out.println("Authorization header ausente ou mal formado ::: " + authHeader + " ::: " + String.valueOf(request.getHeaderNames()));
            }
        }
        if (username != null && SecurityContextHolder.getContext().getAuthentication() == null) {
            UsernamePasswordAuthenticationToken authToken = new UsernamePasswordAuthenticationToken(username, null, Collections.emptyList());
            authToken.setDetails((Object)new WebAuthenticationDetailsSource().buildDetails(request));
            SecurityContextHolder.getContext().setAuthentication((Authentication)authToken);
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

