/*
 * Decompiled with CFR 0.152.
 */
package com.egarantias.utils;

import com.egarantias.utils.JwtProvider;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwtException;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.security.Key;
import java.util.Date;
import org.springframework.stereotype.Component;

@Component
public class Jwt {
    private final JwtProvider jwtProvider;
    private final long expirationMillis = 43200000L;

    public Jwt(JwtProvider jwtProvider) {
        this.jwtProvider = jwtProvider;
    }

    public String generateToken(String username) {
        System.out.println("The security key " + String.valueOf(this.jwtProvider.getKey()));
        return Jwts.builder().setSubject(username).setIssuedAt(new Date()).setExpiration(new Date(System.currentTimeMillis() + 43200000L)).signWith((Key)this.jwtProvider.getKey(), SignatureAlgorithm.HS256).compact();
    }

    public String extractUsername(String token) {
        return ((Claims)Jwts.parserBuilder().setSigningKey((Key)this.jwtProvider.getKey()).build().parseClaimsJws(token).getBody()).getSubject();
    }

    public boolean validateToken(String token) {
        try {
            Jwts.parserBuilder().setSigningKey((Key)this.jwtProvider.getKey()).build().parseClaimsJws(token);
            return true;
        }
        catch (JwtException | IllegalArgumentException e) {
            return false;
        }
    }
}

