/*
 * Decompiled with CFR 0.152.
 */
package com.egarantias.utils;

import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.security.Keys;
import jakarta.annotation.PostConstruct;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Base64;
import javax.crypto.SecretKey;
import org.springframework.stereotype.Service;

@Service
public class JwtProvider {
    private static final String JWT_FILE = "jwt_file.key";
    private SecretKey key;

    public SecretKey getKey() {
        return this.key;
    }

    @PostConstruct
    private void init() {
        block13: {
            try {
                File file = new File(JWT_FILE);
                if (file.exists()) {
                    try (BufferedReader reader = new BufferedReader(new FileReader(file));){
                        String base64key = reader.readLine();
                        byte[] decodeKey = Base64.getDecoder().decode(base64key);
                        this.key = Keys.hmacShaKeyFor((byte[])decodeKey);
                        break block13;
                    }
                }
                this.key = Keys.secretKeyFor((SignatureAlgorithm)SignatureAlgorithm.HS256);
                try (FileWriter writer = new FileWriter(file);){
                    String base64Key = Base64.getEncoder().encodeToString(this.key.getEncoded());
                    writer.write(base64Key);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Ocoreu uma falha ao inicializar o gerenciador de chave JWT", e);
            }
        }
    }
}

