/*
 * Decompiled with CFR 0.152.
 */
package com.egarantias.utils;

import com.egarantias.models.KycReferenceSequence;
import com.egarantias.services.repository.KycReferenceSequenceRepository;
import jakarta.transaction.Transactional;
import java.math.BigDecimal;
import java.security.SecureRandom;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Random;
import java.util.UUID;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class SystemUtils {
    private static final String LETTERS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final Random RANDOM = new SecureRandom();
    private final KycReferenceSequenceRepository kycReferenceSequenceRepository;
    private static final String[] units = new String[]{"", "um", "dois", "tr\u00eas", "quatro", "cinco", "seis", "sete", "oito", "nove", "dez", "onze", "doze", "treze", "quatorze", "quinze", "dezesseis", "dezessete", "dezoito", "dezenove"};
    private static final String[] dozens = new String[]{"", "", "vinte", "trinta", "quarenta", "cinquenta", "sessenta", "setenta", "oitenta", "noventa"};
    private static final String[] hundreds = new String[]{"", "cem", "duzentos", "trezentos", "quatrocentos", "quinhentos", "seiscentos", "setecentos", "oitocentos", "novecentos"};

    public SystemUtils(KycReferenceSequenceRepository kycReferenceSequenceRepository) {
        this.kycReferenceSequenceRepository = kycReferenceSequenceRepository;
    }

    public static String generateReference() {
        String prefix = "FG";
        String datePart = LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        String randomPart = UUID.randomUUID().toString().substring(0, 6).toUpperCase();
        return String.format("%s-%s-%s", prefix, datePart, randomPart);
    }

    @Transactional
    public String generateReference(int clientType, String institutionCode) {
        LocalDate now = LocalDate.now();
        int year = now.getYear();
        String month = String.format("%02d", now.getMonthValue());
        String yearTwoDigits = String.format("%02d", year % 100);
        KycReferenceSequence seq = this.kycReferenceSequenceRepository.findByYear(year).orElseGet(() -> new KycReferenceSequence(year, Long.valueOf(0L)));
        seq.setLastNumber(Long.valueOf(seq.getLastNumber() + 1L));
        this.kycReferenceSequenceRepository.save((Object)seq);
        String sequentialPart = String.format("%012d", seq.getLastNumber());
        return sequentialPart + clientType + month + yearTwoDigits + institutionCode;
    }

    public static String convertDecimalToWords(BigDecimal valor) {
        if (valor.signum() == 0) {
            return "zero mt";
        }
        long parteInteira = valor.longValue();
        int centavos = valor.remainder(BigDecimal.ONE).movePointRight(2).intValue();
        Object extenso = "";
        if (parteInteira > 0L) {
            extenso = (String)extenso + SystemUtils.valueInWords((int)((int)(parteInteira / 1000000L))) + (String)(parteInteira >= 1000000L ? " milh\u00e3o" + (parteInteira >= 2000000L ? "s" : "") + " " : "");
            extenso = (String)extenso + SystemUtils.valueInWords((int)((int)(parteInteira / 1000L % 1000L))) + (parteInteira >= 1000L ? " mil " : "");
            extenso = (String)extenso + SystemUtils.valueInWords((int)((int)(parteInteira % 1000L)));
            extenso = (String)extenso + (parteInteira == 1L ? " metical" : " meticais");
        }
        if (centavos > 0) {
            if (!((String)extenso).isEmpty()) {
                extenso = (String)extenso + " e ";
            }
            extenso = (String)extenso + SystemUtils.valueInWords((int)centavos) + (centavos == 1 ? " centavo" : " centavos");
        }
        return ((String)extenso).trim().replaceAll(" +", " ");
    }

    public static String valueInWords(int numero) {
        if (numero == 0) {
            return "";
        }
        if (numero < 20) {
            return units[numero];
        }
        if (numero < 100) {
            return dozens[numero / 10] + (String)(numero % 10 != 0 ? " e " + units[numero % 10] : "");
        }
        if (numero == 100) {
            return "cem";
        }
        return hundreds[numero / 100] + (String)(numero % 100 != 0 ? " e " + SystemUtils.valueInWords((int)(numero % 100)) : "");
    }
}

